/***************************************************************************
                                prefsbase.cpp  -  description
                                -------------------
        begin                   : Sun Mar 4 2001
        copyright               : (C) 2001 by Otto Bruggeman
                                  and John Firebaugh
        email                   : otto.bruggeman@home.nl
                                  jfirebaugh@kde.org
****************************************************************************/
 
/***************************************************************************
**
**   This program is free software; you can redistribute it and/or modify
**   it under the terms of the GNU General Public License as published by
**   the Free Software Foundation; either version 2 of the License, or
**   (at your option) any later version.
**
***************************************************************************/

#include <tqlayout.h>
#include <tqobjectlist.h>

#include "pagebase.h"

PageBase::PageBase( TQWidget* parent ) : KTabCtl( parent )
{

}

PageBase::~PageBase()
{

}

/** No descriptions */
TQSize PageBase::sizeHintForWidget( TQWidget* widget )
{
	//
	// The size is computed by adding the tqsizeHint().height() of all
	// widget tqchildren and taking the width of the widest child and adding
	// tqlayout()->margin() and tqlayout()->spacing()
	//

	// this code in this method has been ripped out of a file in kbabel
	// so copyright goes to the kbabel authors.

	TQSize size;

	int numChild = 0;
	TQObjectList l = widget->childrenListObject();

	for( uint i=0; i < l.count(); i++ )
	{
		TQObject *o = l.at(i);
		if( o->isWidgetType() )
		{
			numChild += 1;
			TQWidget *w=((TQWidget*)o);

			TQSize s = w->tqsizeHint();
			if( s.isEmpty() == true )
			{
				s = TQSize( 50, 100 ); // Default size
			}
			size.setHeight( size.height() + s.height() );
			if( s.width() > size.width() )
			{
				size.setWidth( s.width() );
			}
		}
	}

	if( numChild > 0 )
	{
		size.setHeight( size.height() + widget->tqlayout()->spacing()*(numChild-1) );
		size += TQSize( widget->tqlayout()->margin()*2, widget->tqlayout()->margin()*2 + 1 );
	}
	else
	{
		size = TQSize( 1, 1 );
	}

	return( size );
}

/** No descriptions */
void PageBase::apply()
{

}

/** No descriptions */
void PageBase::restore()
{

}

/** No descriptions */
void PageBase::setDefaults()
{

}

#include "pagebase.moc"
