/***************************************************************************
                                diffprefs.h  -  description
                                -------------------
        begin                   : Sun Mar 4 2001
        copyright               : (C) 2001-2004 Otto Bruggeman
                                  (C) 2001-2003 John Firebaugh
        email                   : otto.bruggeman@home.nl
                                  jfirebaugh@kde.org
****************************************************************************/

/***************************************************************************
**
**   This program is free software; you can redistribute it and/or modify
**   it under the terms of the GNU General Public License as published by
**   the Free Software Foundation; either version 2 of the License, or
**   (at your option) any later version.
**
***************************************************************************/

#ifndef DIFFPAGE_H
#define DIFFPAGE_H

#include "pagebase.h"

class TQCheckBox;
class TQDialog;
class TQSpinBox;
class TQStringList;
class TQVButtonGroup;
class TQWidget;

class KLineEdit;
class KComboBox;
class KEditListBox;
class KURLComboBox;
class KURLRequester;

class DiffSettings;

class DiffPage : public PageBase
{
Q_OBJECT
  TQ_OBJECT
public:
	DiffPage( TQWidget* );
	~DiffPage();

public:
	void setSettings( DiffSettings* );
	DiffSettings* settings( void );

public:
	virtual void restore();
	virtual void apply();
	virtual void setDefaults();

protected slots:
	void slotShowRegExpEditor();
	void slotExcludeFilePatternToggled( bool );
	void slotExcludeFileToggled( bool );

private:
	void addDiffTab();
	void addFormatTab();
	void addOptionsTab();
	void addExcludeTab();

public:
	DiffSettings*  m_settings;

	KURLRequester* m_diffURLRequester;

	TQCheckBox*     m_smallerCheckBox;
	TQCheckBox*     m_largerCheckBox;
	TQCheckBox*     m_tabsCheckBox;
	TQCheckBox*     m_caseCheckBox;
	TQCheckBox*     m_linesCheckBox;
	TQCheckBox*     m_whitespaceCheckBox;
	TQCheckBox*     m_allWhitespaceCheckBox;
	TQCheckBox*     m_ignoreTabExpansionCheckBox;

	TQCheckBox*     m_ignoreRegExpCheckBox;
	KLineEdit*     m_ignoreRegExpEdit;
	TQStringList*   m_ignoreRegExpEditHistory;
	TQDialog*       m_ignoreRegExpDialog;

	TQCheckBox*     m_excludeFilePatternCheckBox;
	KEditListBox*  m_excludeFilePatternEditListBox;
	
	TQCheckBox*     m_excludeFileCheckBox;
	KURLComboBox*  m_excludeFileURLComboBox;
	KURLRequester* m_excludeFileURLRequester;

	// loc == lines of context
	TQSpinBox*      m_locSpinBox;

	TQVButtonGroup* m_modeButtonGroup;
	TQVButtonGroup* m_diffProgramGroup;
};

#endif
