/***************************************************************************
                                kcompareurldialog.h  -  description
                                -------------------
        begin                   : Sun Mar 4 2001
        copyright               : (C) 2001-2004 Otto Bruggeman
                                  (C) 2001-2003 John Firebaugh
        email                   : otto.bruggeman@home.nl
                                  jfirebaugh@kde.org
****************************************************************************/

/***************************************************************************
**
**   This program is free software; you can redistribute it and/or modify
**   it under the terms of the GNU General Public License as published by
**   the Free Software Foundation; either version 2 of the License, or
**   (at your option) any later version.
**
***************************************************************************/

#ifndef KOMPAREURLDIALOG_H
#define KOMPAREURLDIALOG_H

#include <kdialogbase.h>
#include <kurl.h>

class TQGroupBox;

class KComboBox;
class KConfig;
class KFileDialog;
class KURLComboBox;
class KURLRequester;

class FilesPage;
class FilesSettings;
class DiffPage;
class DiffSettings;
class ViewPage;
class ViewSettings;

class KompareURLDialog : public KDialogBase
{
	Q_OBJECT
  TQ_OBJECT

public:
	KompareURLDialog( TQWidget* parent = 0, const char* name = 0 );
	~KompareURLDialog();

	KURL getFirstURL() const;
	KURL getSecondURL() const;
	TQString encoding() const;

	void setFirstGroupBoxTitle ( const TQString& title );
	void setSecondGroupBoxTitle( const TQString& title );

	void setGroup( const TQString& groupName );

	void setFirstURLRequesterMode ( unsigned int mode );
	void setSecondURLRequesterMode( unsigned int mode );

protected slots:
	virtual void slotOk();

private slots:
	void slotEnableOk();

private:
	FilesPage*     m_filesPage;
	FilesSettings* m_filesSettings;
	DiffPage*      m_diffPage;
	DiffSettings*  m_diffSettings;
	ViewPage*      m_viewPage;
	ViewSettings*  m_viewSettings;
};

#endif
