#include <kdebug.h>
#include <kconfig.h>
#include <klocale.h>

#include "bugcommand.h"

TQString BugCommand::name()
{
    return i18n("Unknown");
}

TQString BugCommand::details()
{
    return TQString();
}

BugCommand *BugCommand::load( KConfig *config, const TQString &type )
{
    TQString bugNumber = config->group();
    // ### this sucks. we better let Bug implement proper persistance,
    // because this way of instantiating a bug object doesn't bring back
    // properties like title, package, etc. (Simon)
    Bug bug = Bug::fromNumber( bugNumber );
    Package pkg = Package(); // hack

    if ( type == "Close" ) {
        return new BugCommandClose( bug, config->readEntry( type ), pkg );
    } else if ( type == "Reopen" ) {
        return new BugCommandReopen( bug, pkg );
    } else if ( type == "Merge" ) {
        return new BugCommandMerge( config->readListEntry( type ), pkg );
    } else if ( type == "Unmerge" ) {
        return new BugCommandUnmerge( bug, pkg );
    } else if ( type == "Reassign" ) {
        return new BugCommandReassign( bug, config->readEntry( type ), pkg );
    } else if ( type == "Retitle" ) {
        return new BugCommandRetitle( bug, config->readEntry( type ), pkg );
    } else if ( type == "Severity" ) {
        return new BugCommandSeverity( bug, config->readEntry( type ), pkg );
    } else if ( type == "Reply" ) {
        return new BugCommandReply( bug, config->readEntry( type ), config->readNumEntry("Recipient",Normal) );
    } else if ( type == "ReplyPrivate" ) {
        TQStringList args = config->readListEntry( type );
        if ( args.count() != 2 ) return 0;
        return new BugCommandReplyPrivate( bug, *(args.at(0)), *(args.at(1)) );
    } else {
      kdDebug() << "Warning! Unknown bug command '" << type << "'" << endl;
      return 0;
    }
}

///////////////////// Close /////////////////////

TQString BugCommandClose::controlString() const
{
    if (m_message.isEmpty()) {
        return "close " + m_bug.number();
    } else {
        return TQString();
    }
}

TQString BugCommandClose::mailAddress() const
{
    kdDebug() << "BugCommandClose::mailAddress(): number: " << m_bug.number() << endl;

    if (m_message.isEmpty()) {
        return TQString();
    } else {
        return m_bug.number() + "-done@bugs.kde.org";
    }
}

TQString BugCommandClose::mailText() const
{
    if (m_message.isEmpty()) {
        return TQString();
    } else {
        return m_message;
    }
}

TQString BugCommandClose::name()
{
    return i18n("Close");
}

TQString BugCommandClose::details() const
{
    return m_message;
}

void BugCommandClose::save( KConfig *config )
{
    config->writeEntry( "Close",m_message );
}

///////////////////// Close Silently /////////////////////

TQString BugCommandCloseSilently::controlString() const
{
    return "done " + m_bug.number();
}

TQString BugCommandCloseSilently::name()
{
    return i18n("Close Silently");
}

void BugCommandCloseSilently::save( KConfig *config )
{
    config->writeEntry( "CloseSilently", true );
}

///////////////////// Reopen /////////////////////

TQString BugCommandReopen::controlString() const
{
    return "reopen " + m_bug.number();
}

TQString BugCommandReopen::name()
{
    return i18n("Reopen");
}

void BugCommandReopen::save( KConfig *config )
{
    config->writeEntry( "Reopen", true );
}

///////////////////// Retitle /////////////////////

TQString BugCommandRetitle::controlString() const
{
    return "retitle " + m_bug.number() + " " + m_title;
}

TQString BugCommandRetitle::name()
{
    return i18n("Retitle");
}

TQString BugCommandRetitle::details() const
{
    return m_title;
}

void BugCommandRetitle::save( KConfig *config )
{
    config->writeEntry( "Retitle", m_title );
}

///////////////////// Merge /////////////////////

TQString BugCommandMerge::controlString() const
{
    return "merge " + m_bugNumbers.join(" ");
}

TQString BugCommandMerge::name()
{
    return i18n("Merge");
}

TQString BugCommandMerge::details() const
{
    return m_bugNumbers.join(", ");
}

void BugCommandMerge::save( KConfig *config )
{
    config->writeEntry( "Merge", m_bugNumbers );
}

///////////////////// Unmerge /////////////////////

TQString BugCommandUnmerge::controlString() const
{
    return "unmerge " + m_bug.number();
}

TQString BugCommandUnmerge::name()
{
    return i18n("Unmerge");
}

void BugCommandUnmerge::save( KConfig *config )
{
    config->writeEntry( "Unmerge", true );
}

///////////////////// Reply /////////////////////

TQString BugCommandReply::mailAddress() const
{
    return m_bug.number() + "@bugs.kde.org";
#if 0
    switch ( m_recipient ) {
      case Normal:
        return m_bug.number() + "@bugs.kde.org";
      case Maintonly:
        return m_bug.number() + "-maintonly@bugs.kde.org";
      case Quiet:
        return m_bug.number() + "-quiet@bugs.kde.org";
    }
    return TQString();
#endif
}

TQString BugCommandReply::mailText() const
{
    return m_message;
}

TQString BugCommandReply::name()
{
    return i18n("Reply");
#if 0
    switch ( m_recipient ) {
      case Normal:
        return i18n("Reply");
      case Maintonly:
        return i18n("Reply (Maintonly)");
      case Quiet:
        return i18n("Reply (Quiet)");
    }
    return TQString();
#endif
}

TQString BugCommandReply::details() const
{
    return m_message;
}

void BugCommandReply::save( KConfig *config )
{
    config->writeEntry( "Reply", m_message );
#if 0
    config->writeEntry( "Recipient", m_recipient );
#endif
}

///////////////////// Reply Private /////////////////////

TQString BugCommandReplyPrivate::mailAddress() const
{
    return m_address;
}

TQString BugCommandReplyPrivate::mailText() const
{
    return m_message;
}

TQString BugCommandReplyPrivate::name()
{
    return i18n("Private Reply");
}

TQString BugCommandReplyPrivate::details() const
{
    return m_message;
}

void BugCommandReplyPrivate::save( KConfig *config )
{
    TQStringList args;
    args << m_address;
    args << m_message;
    config->writeEntry( "ReplyPrivate", args );
}

///////////////////// Severity /////////////////////

TQString BugCommandSeverity::controlString() const
{
    return "severity " + m_bug.number() + " " + m_severity.lower();
}

TQString BugCommandSeverity::name()
{
    return i18n("Severity");
}

TQString BugCommandSeverity::details() const
{
    return m_severity;
}

void BugCommandSeverity::save( KConfig *config )
{
    config->writeEntry( "Severity", m_severity );
}

///////////////////// Reassign /////////////////////

TQString BugCommandReassign::controlString() const
{
    return "reassign " + m_bug.number() + " " + m_package;
}

TQString BugCommandReassign::name()
{
    return i18n("Reassign");
}

TQString BugCommandReassign::details() const
{
    return m_package;
}

void BugCommandReassign::save( KConfig *config )
{
    config->writeEntry( "Reassign", m_package );
}
