#include <tqradiobutton.h>
#include <tqslider.h>
#include <tqspinbox.h>  
#include <tqcheckbox.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <klocale.h>
#include <kfiledialog.h>
#include <kurlrequester.h>
#include <tqtoolbutton.h>
#include <klineedit.h>
#include <kstandarddirs.h>
#include <knuminput.h>

#include "dbse2.h"
#include "preferenceswidget.h"

KDB2PreferencesWidget::KDB2PreferencesWidget(TQWidget *parent, const char* name)
		: PrefWidget(parent,name) 
{
	TQVBoxLayout *tqlayout = new TQVBoxLayout(this);
//	TQLabel *label = new TQLabel(i18n("Settings for KDE Database Search Engine"),this);
//	tqlayout->addWidget(label);

	dbpw = new DBSearchEnginePrefWidget(this);
	dbpw->dbDirectory->setMode(KFile::Directory | KFile::LocalOnly);
	dbpw->show();	
	tqlayout->addWidget(dbpw);
	setMinimumSize(300,300);

	standard();

//    connect(dbpw->browseTB_3,TQT_SIGNAL(clicked()),TQT_SLOT(browse1()));

    emit restoreNow();   //Fill with actual params.			

}

KDB2PreferencesWidget::~KDB2PreferencesWidget()
{
}

void KDB2PreferencesWidget::apply()
{
emit applyNow();
}

void KDB2PreferencesWidget::cancel()
{
emit restoreNow();
}

void KDB2PreferencesWidget::standard()
{
TQString defaultDir;
 KStandardDirs * dirs = KGlobal::dirs();
 if(dirs)
 {
     defaultDir = dirs->saveLocation("data");
     if(defaultDir.right(1)!="/")
         defaultDir+="/";
     defaultDir += "kbabeldict/dbsearchengine2";
 }
dbpw->dbDirectory->setURL(defaultDir);

dbpw->autoUpdate->setChecked(true);

dbpw->useSentence->setChecked(true);
dbpw->useGlossary->setChecked(true);
dbpw->useExact->setChecked(true);
dbpw->useDivide->setChecked(true);
dbpw->useAlpha->setChecked(true);
dbpw->useWordByWord->setChecked(true);
dbpw->useDynamic->setChecked(true);
dbpw->scoreDivide->setValue(90);
dbpw->scoreExact->setValue(100);
dbpw->scoreSentence->setValue(90);
dbpw->scoreWordByWord->setValue(70);
dbpw->scoreGlossary->setValue(98);
dbpw->scoreAlpha->setValue(98);
dbpw->scoreDynamic->setValue(80);

dbpw->numberOfResult->setValue(5);
dbpw->minScore->setValue(60);

dbpw->firstCapital->setChecked(true);
dbpw->allCapital->setChecked(false);
dbpw->accelerator->setChecked(true);
dbpw->sameLetter->setChecked(true);
dbpw->checkLang->setChecked(true);
dbpw->useFilters->setChecked(false);
dbpw->dateToday->setChecked(false);
/*
 */
 //dbpw->dirInput->setURL(defaultDir); 
}

#include "preferenceswidget.moc"
