/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 2002-2004  by Stanislav Visnovsky
			    <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  In addition, as a special exception, the copyright holders give
  permission to link the code of this program with any edition of
  the TQt library by Trolltech AS, Norway (or with modified versions
  of TQt that use the same license as TQt), and distribute linked
  combinations including the two.  You must obey the GNU General
  Public License in all respects for all of the code used other than
  TQt. If you modify this file, you may extend this exception to
  your version of the file, but you are not obligated to do so.  If
  you do not wish to do so, delete this exception statement from
  your version.

**************************************************************************** */

#include "taglistview.h"

#include <tqlayout.h>
#include <tqwhatsthis.h>

#include <kcursor.h>
#include <klistbox.h>
#include <klocale.h>

#include "kbcatalog.h"

using namespace KBabel;

TagListView::TagListView(KBCatalog* catalog,TQWidget *parent, Project::Ptr project)
    : KBCatalogView(catalog,parent,project)
{
    TQVBoxLayout* tqlayout = new TQVBoxLayout( this );
    tqlayout->setResizeMode( TQLayout::Minimum );

    _tagBox = new KListBox (this, "taglist textview");
    
    tqlayout->addWidget (_tagBox);
    
    connect(_tagBox,TQT_SIGNAL(selected(const TQString&))
            , this, TQT_SIGNAL(signalTagSelected(const TQString&)));
    connect(_tagBox,TQT_SIGNAL(highlighted(int))
            , this, TQT_SIGNAL(signalHighlightedTagChanged(int)));
	    
    connect(_catalog, TQT_SIGNAL(signalFileOpened(bool))
	    , this, TQT_SLOT(setDisabled(bool)));
}

void TagListView::updateView()
{
    _tagBox->clear();
    _tagBox->insertStringList(_catalog->tagList(_currentIndex));
    _tagBox->setCurrentItem(0);
}

void TagListView::highlightTag(int index)
{
    _tagBox->setCurrentItem(index);    
}

#include "taglistview.moc"
