/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  In addition, as a special exception, the copyright holders give
  permission to link the code of this program with any edition of
  the TQt library by Trolltech AS, Norway (or with modified versions
  of TQt that use the same license as TQt), and distribute linked
  combinations including the two.  You must obey the GNU General
  Public License in all respects for all of the code used other than
  TQt. If you modify this file, you may extend this exception to
  your version of the file, but you are not obligated to do so.  If
  you do not wish to do so, delete this exception statement from
  your version.

**************************************************************************** */
#include "cmdedit.h"

#include <tqlistbox.h>
#include <tqlineedit.h>
#include <tqpushbutton.h>
#include <tqlayout.h>
#include <tqlabel.h>
#include <tqtoolbutton.h>
#include <klocale.h>
#include <kdialog.h>


CmdEdit::CmdEdit(TQWidget* parent, const char* name)
       : TQWidget(parent,name)
{
    TQGridLayout* tqlayout = new TQGridLayout( this , 1 , 1 );
    tqlayout->setSpacing( KDialog::spacingHint() );

    TQLabel* nameLabel = new TQLabel( i18n("Command &Label:"), this);
    TQLabel* cmdLabel = new TQLabel( i18n("Co&mmand:"), this);
    tqlayout->addWidget( nameLabel, 0 , 0 );
    tqlayout->addWidget( cmdLabel, 0 , 1 );

    _cmdNameEdit = new TQLineEdit( this , "cmdNameEdit" );
    _cmdNameEdit->setMaxLength(20);
    nameLabel->setBuddy(_cmdNameEdit);
    tqlayout->addWidget( _cmdNameEdit , 1 , 0 );

    _cmdEdit = new TQLineEdit( this , "cmdEdit" );
    cmdLabel->setBuddy(_cmdEdit);
    tqlayout->addWidget( _cmdEdit , 1 , 1 );


    _addButton = new TQPushButton( i18n("&Add"), this );
    _addButton->setEnabled(false);
    tqlayout->addWidget( _addButton , 1 , 2 );

    _editButton = new TQPushButton( i18n("&Edit"), this );
    _editButton->setEnabled(false);
    tqlayout->addWidget( _editButton , 3 , 2 );

    _removeButton = new TQPushButton( i18n("&Remove"), this );
    _removeButton->setEnabled(false);
    tqlayout->addWidget( _removeButton , 4 , 2 );

    TQHBoxLayout* hbox = new TQHBoxLayout();
    tqlayout->addLayout(hbox,5,2);

    _upButton = new TQToolButton(UpArrow,this);
    _upButton->setFixedSize(20,20);
    _upButton->setEnabled(false);
    hbox->addWidget( _upButton );

    _downButton = new TQToolButton(DownArrow,this);
    _downButton->setFixedSize(20,20);
    _downButton->setEnabled(false);
    hbox->addWidget( _downButton);

    _commandNames = new TQListBox( this , "commandNamesBox" );
    _commandNames->setMinimumSize(100, 100);
    tqlayout->addMultiCellWidget( _commandNames , 3 , 6 , 0 , 0);

    _commands = new TQListBox( this , "commandsBox" );
    _commands->setMinimumSize(160, 100);
    tqlayout->addMultiCellWidget( _commands , 3 , 6 , 1 ,1 );


    tqlayout->setColStretch(0,1);
    tqlayout->setColStretch(1,2);
    tqlayout->setColStretch(2,0);

    tqlayout->addRowSpacing(2, KDialog::spacingHint());
    tqlayout->addRowSpacing(6, KDialog::spacingHint());

    setMinimumSize(tqlayout->tqsizeHint());


    connect(_addButton , TQT_SIGNAL(clicked()) , this , TQT_SLOT(addCmd()) ) ;
    connect(_editButton , TQT_SIGNAL(clicked()) , this , TQT_SLOT(editCmd()) );
    connect(_removeButton , TQT_SIGNAL(clicked()) , this , TQT_SLOT(removeCmd()) );
    connect(_upButton , TQT_SIGNAL(clicked()) , this , TQT_SLOT(upCmd()) ) ;
    connect(_downButton , TQT_SIGNAL(clicked()) , this , TQT_SLOT(downCmd()) );

    connect(_commands , TQT_SIGNAL(highlighted(int)) , this, TQT_SLOT(cmdHighlighted(int)) );
    connect(_commandNames , TQT_SIGNAL(highlighted(int)) , this, TQT_SLOT(cmdNameHighlighted(int)) );
    connect(_commands , TQT_SIGNAL(selected(int)) , this, TQT_SLOT(editCmd()) );
    connect(_commandNames , TQT_SIGNAL(selected(int)) , this, TQT_SLOT(editCmd()) );

    connect(_cmdEdit, TQT_SIGNAL(textChanged(const TQString&)) , this , TQT_SLOT(checkAdd()) );
    connect(_cmdNameEdit, TQT_SIGNAL(textChanged(const TQString&)) , this , TQT_SLOT(checkAdd()) );
}

void CmdEdit::setCommands(const TQStringList& commands,const TQStringList& commandNames)
{
   _commands->clear();
   _commands->insertStringList(commands);

   _commandNames->clear();
   _commandNames->insertStringList(commandNames);
}

void CmdEdit::commands(TQStringList& commands, TQStringList& commandNames)
{
   commands.clear();
   commandNames.clear();

   int items=_commands->count();

   int i=0;
   for( i=0 ; i< items ; i++)
   {
      commands.append( _commands->text(i) );
      commandNames.append( _commandNames->text(i) );
   }
}

void CmdEdit::addCmd()
{
   TQString cmd = _cmdEdit->text();
   TQString cmdName = _cmdNameEdit->text();
   _cmdEdit->clear();
   _cmdNameEdit->clear();

   if(_commands->currentText() == cmd || _commandNames->currentText() == cmdName)
   {
      int current = _commands->currentItem();
      _commands->changeItem(cmd,current);
      _commandNames->changeItem(cmdName,current);
   }
   else
   {
      _commands->insertItem(cmd);
      _commandNames->insertItem(cmdName);
   }
   
   emit widgetChanged();
}

void CmdEdit::removeCmd()
{
   int current=_commands->currentItem();

   _commands->removeItem(current);
   _commandNames->removeItem(current);

   if(_commands->count() == 0)
   {
      _removeButton->setEnabled(false);
      _editButton->setEnabled(false);
      _upButton->setEnabled(false);
      _downButton->setEnabled(false);
   }
   else
   {
      if(current > (int)_commands->count()-1)
         current=_commands->count()-1;

      _commands->setSelected(current,true);
      _commandNames->setSelected(current,true);
      cmdHighlighted(current);
   }

   emit widgetChanged();
}

void CmdEdit::upCmd()
{
   TQString cmd = _commands->currentText();
   TQString cmdName = _commandNames->currentText();
   int index=_commands->currentItem();

   _commands->removeItem(index);
   _commandNames->removeItem(index);

   _commands->insertItem(cmd , index-1);
   _commandNames->insertItem(cmdName , index-1);

   _commands->clearSelection();
   _commandNames->clearSelection();

   _commands->setSelected(index-1,true);
   _commandNames->setSelected(index-1,true);

   cmdHighlighted(index-1);

   emit widgetChanged();
}

void CmdEdit::downCmd()
{
   TQString cmd = _commands->currentText();
   TQString cmdName = _commandNames->currentText();
   int index=_commands->currentItem();

   _commands->removeItem(index);
   _commandNames->removeItem(index);

   _commands->insertItem(cmd , index+1);
   _commandNames->insertItem(cmdName , index+1);

   _commands->clearSelection();
   _commandNames->clearSelection();

   _commands->setSelected(index+1,true);
   _commandNames->setSelected(index+1,true);

   cmdHighlighted(index+1);

   emit widgetChanged();
}

void CmdEdit::cmdHighlighted(int index)
{
   _commandNames->blockSignals(true);
   _commandNames->setCurrentItem(index);
   _commandNames->blockSignals(false);

   _removeButton->setEnabled(true);
   _editButton->setEnabled(true);

   if(index == (int)(_commands->count()-1))
      _downButton->setEnabled(false);
   else
      _downButton->setEnabled(true);

   if(index==0)
      _upButton->setEnabled(false);
   else
      _upButton->setEnabled(true);

}

void CmdEdit::cmdNameHighlighted(int index)
{
   _commands->blockSignals(true);
   _commands->setCurrentItem(index);
   _commands->blockSignals(false);

   _removeButton->setEnabled(true);
   _editButton->setEnabled(true);

   if(index == (int)(_commands->count()-1))
      _downButton->setEnabled(false);
   else
      _downButton->setEnabled(true);

   if(index==0)
      _upButton->setEnabled(false);
   else
      _upButton->setEnabled(true);
}

void CmdEdit::editCmd()
{
   _cmdEdit->setText(_commands->currentText());
   _cmdNameEdit->setText(_commandNames->currentText());

   emit widgetChanged();
}

void CmdEdit::checkAdd()
{
   _addButton->setEnabled( !(_cmdEdit->text().isEmpty() || _cmdNameEdit->text().isEmpty()) );
}

#include "cmdedit.moc"
