/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 2003 by Stanislav Visnovsky
                            <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  In addition, as a special exception, the copyright holders give
  permission to link the code of this program with any edition of
  the TQt library by Trolltech AS, Norway (or with modified versions
  of TQt that use the same license as TQt), and distribute linked
  combinations including the two.  You must obey the GNU General
  Public License in all respects for all of the code used other than
  TQt. If you modify this file, you may extend this exception to
  your version of the file, but you are not obligated to do so.  If
  you do not wish to do so, delete this exception statement from
  your version.

**************************************************************************** */
#ifndef KBABELDATATOOL_H
#define KBABELDATATOOL_H

#include <kdatatool.h>

namespace KBabel
{

/**
 * This class represents a base class for a KBabel @ref KDataTool.
 * It supports automatic settings management.
 *
 * @short This class represents a base class for a KBabel data tool.
 */                                                                              
class KBabelDataTool: public KDataTool
{
    Q_OBJECT
  TQ_OBJECT
    
protected:
    KBabelDataTool( TQObject* parent, const char* name ) : KDataTool( parent, name ) {}
public slots:
    /** The only method to be redefined in inherited classes.
     *  This method is called everytime the settings are changed.
     *  @param project is ID of the project, for which the settings changed.
     */
    virtual void settingsChanged(const TQString &project) = 0;
};

}

#endif // KBABELDATATOOL_H
