echo "Creating $LOCATION_ROOT/$APP_NAME_LC/${APP_NAME_LC}view.h...";
cat << EOF > $LOCATION_ROOT/$APP_NAME_LC/${APP_NAME_LC}view.h
#ifndef ${APP_NAME_UC}VIEW_H
#define ${APP_NAME_UC}VIEW_H

#include <tqwidget.h>
#include <kparts/part.h>
#include <${APP_NAME_LC}iface.h>

class TQPainter;
class KURL;

/**
 * This is the main view class for ${APP_NAME}.  Most of the non-menu,
 * non-toolbar, and non-statusbar (e.g., non frame) GUI code should go
 * here.
 *
 * This ${APP_NAME_LC} uses an HTML component as an example.
 *
 * @short Main view
 * @author $AUTHOR <$EMAIL>
 * @version $APP_VERSION
 */
class ${APP_NAME}View : public TQWidget, public ${APP_NAME}Iface
{
    Q_OBJECT
  TQ_OBJECT
public:
	/**
	 * Default constructor
	 */
    ${APP_NAME}View(TQWidget *parent);

	/**
	 * Destructor
	 */
    virtual ~${APP_NAME}View();

    /**
     * Random 'get' function
     */
    TQString currentURL();

    /**
     * Random 'set' function accessed by DCOP
     */
    virtual void openURL(TQString url);

    /**
     * Random 'set' function
     */
    virtual void openURL(const KURL& url);

    /**
     * Print this view to any medium -- paper or not
     */
    void print(TQPainter *, int height, int width);

signals:
    /**
     * Use this signal to change the content of the statusbar
     */
    void signalChangeStatusbar(const TQString& text);

    /**
     * Use this signal to change the content of the caption
     */
    void signalChangeCaption(const TQString& text);

private slots:
    void slotOnURL(const TQString& url);
    void slotSetTitle(const TQString& title);

private:
    KParts::ReadOnlyPart *m_html;
};

#endif // ${APP_NAME_UC}VIEW_H
