#ifndef _HISTORY_MANAGER_H
#define _HISTORY_MANAGER_H

#include <kurl.h>
#include <tqvaluestack.h>
#include <tqobject.h>

class HistoryManager : public TQObject {
  Q_OBJECT
  TQ_OBJECT
  public:
    HistoryManager(TQObject *parent = NULL);
    ~HistoryManager();
    KURL back();
    KURL forward();
    void addURL(const KURL &);
    enum Buttons {
      Back,
      Forward
    };
  signals:
    void uiChanged(int, bool);
  protected:
    TQValueStack<KURL> back_stack;
    TQValueStack<KURL> forward_stack;
    KURL currentURL;
};
  
#endif
