//////////////////////////////////////////////////////////////////////////
// bookmarkListItem.h                                                   //
//                                                                      //
// Copyright (C)  2005  Lukas Tinkl <lukas@kde.org>                     //
//                                                                      //
// This program is free software; you can redistribute it and/or        //
// modify it under the terms of the GNU General Public License          //
// as published by the Free Software Foundation; either version 2       //
// of the License, or (at your option) any later version.               //
//                                                                      //
// This program is distributed in the hope that it will be useful,      //
// but WITHOUT ANY WARRANTY; without even the implied warranty of       //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        //
// GNU General Public License for more details.                         //
//                                                                      //
// You should have received a copy of the GNU General Public License    //
// along with this program; if not, write to the Free Software          //
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA            //
// 02110-1301, USA.                                                     //
//////////////////////////////////////////////////////////////////////////

#ifndef _BOOKMARKLISTITEM_H_
#define _BOOKMARKLISTITEM_H_

#include <tqdatetime.h>

#include <klistview.h>
#include <kurl.h>

#include <time.h>

class TQString;

class BookmarkListItem: public KListViewItem
{
public:
    BookmarkListItem( TQListView *parent, const TQString & url, const TQString & desc, time_t time );
    KURL url() const;
    TQDateTime date() const;
    TQString desc() const;

protected:
    virtual int compare( TQListViewItem * i, int col, bool ascending ) const;
    virtual TQString text( int column ) const;

    KURL m_url;
    TQString m_desc;
    TQDateTime m_dateTime;
};

#endif
