/*****************************************************
 * FSView, a simple TreeMap application
 *
 * (C) 2002, Josef Weidendorfer
 */

#include <kapplication.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <kglobal.h>
#include <kconfig.h>

#include "fsview.h"


static KCmdLineOptions options[] =
{
  { "+[folder]", I18N_NOOP("View filesystem starting from this folder"), 0 },
  KCmdLineLastOption // End of options.
};

int main(int argc, char* argv[])
{
  // KDE compliant startup
  KAboutData aboutData("fsview", I18N_NOOP("FSView"), "0.1",
                       I18N_NOOP("Filesystem Viewer"),
                       KAboutData::License_GPL,
                       I18N_NOOP("(c) 2002, Josef Weidendorfer"));
  KCmdLineArgs::init(argc, argv, &aboutData);
  KCmdLineArgs::addCmdLineOptions(options);
  KApplication a;

  KConfigGroup gconfig(KGlobal::config(), TQCString("General"));
  TQString path = gconfig.readPathEntry("Path", ".");

  KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
  if (args->count()>0) path = args->arg(0);

  // TreeMap Widget as toplevel window
  FSView w(new Inode());

  TQObject::connect(&w,TQT_SIGNAL(clicked(TreeMapItem*)),
                   &w,TQT_SLOT(selected(TreeMapItem*)));
  TQObject::connect(&w,TQT_SIGNAL(returnPressed(TreeMapItem*)),
                   &w,TQT_SLOT(selected(TreeMapItem*)));
  TQObject::connect(&w,
                   TQT_SIGNAL(contextMenuRequested(TreeMapItem*,const TQPoint&)),
                   &w,TQT_SLOT(contextMenu(TreeMapItem*, const TQPoint&)));

  w.setPath(path);
  w.show();

  a.connect( &a, TQT_SIGNAL( lastWindowClosed() ), &w, TQT_SLOT( quit() ) );
  return a.exec();
}
