/***************************************************************************
                              domlistviewitem.h
                             -------------------

    author               : Andreas Schlapbach
    email                : schlpbch@iam.unibe.ch
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DOMLISTVIEWITEMS_H
#define DOMLISTVIEWITEMS_H
 
#include <dom/dom_node.h>

#include <tqlistview.h>
#include <tqcolor.h>
#include <tqfont.h>

class DOMListViewItem : public TQListViewItem
{

 public:
   DOMListViewItem( const DOM::Node &, TQListView *parent );
   DOMListViewItem( const DOM::Node &, TQListView *parent, TQListViewItem *after ); 
   DOMListViewItem( const DOM::Node &, TQListViewItem *parent );
   DOMListViewItem( const DOM::Node &, TQListViewItem *parent, TQListViewItem *after );
   virtual ~DOMListViewItem();
 
  virtual void paintCell( TQPainter *p, const TQColorGroup &cg,
			  int column, int width, int tqalignment );  

  void setColor( const TQColor &color) { m_color = color; }

  void setFont( const TQFont &font) { m_font = font;}
  void setItalic( bool b) {m_font.setItalic(b);}
  void setBold( bool b) {m_font.setBold(b);}
  void setUnderline(bool b) {m_font.setUnderline(b);}
  
  bool isClosing() const { return clos; }
  void setClosing(bool s) { clos = s; }

  DOM::Node node() const { return m_node; }

 private:
  void init();
  TQColor m_color;
  TQFont m_font;
  DOM::Node m_node;
  bool clos;
};
#endif
