#ifndef ATLANTIK_EDITOR_H
#define ATLANTIK_EDITOR_H

#include <kmainwindow.h>
#include <tqstring.h>
#include <tqcolor.h>
#include <tqstringlist.h>

#include <atlantic/estate.h>

#include "group.h"

class TQCheckBox;
class TQGridLayout;
class TQLineEdit;
class TQSpinBox;

class KColorButton;
class KComboBox;
class KListBox;
class KPushButton;

enum EstateType { Street = 0, Cards, FreeParking, ToJail, Tax, Jail };

class ConfigEstate : public Estate
{
	public:
	ConfigEstate(int estateId);
	void setEstateId(const int estateId);
	int type()const { return m_type; }
	void setType(const int type);
	const TQString &group() { return m_group; }
	void setGroup(const TQString &group);
	int price()const { return m_price; }
	void setPrice(int);
	int rent(int _h)const { return m_rent[_h]; }
	void setRent(const int, const int);
	int tax()const { return m_tax; }
	void setTax(const int);
	int taxPercentage() { return m_taxPercentage; }
	void setTaxPercentage(const int);
	const TQString &takeCard() { return m_takeCard; }
	void setTakeCard(const TQString &);
	const TQColor &forceBg() { return m_forceBg; }
	void setForceBg(const TQColor &);
	bool go()const { return m_go; }
	void setGo(const bool);
	int passMoney()const { return m_passMoney; }
	void setPassMoney(const int);

	void setChanged(bool);

	private:
	int m_type;
	TQString m_group;
	int m_rent[6];
	int m_price;
	int m_tax;
	int m_taxPercentage;
	TQString m_takeCard;
	TQColor m_forceBg;
	bool m_go;
	int m_passMoney;
};
typedef TQPtrList<ConfigEstate> EstateList;

struct Card
{
	Card() {}
	Card(const TQString &newName) { name = newName; }
	TQString name;
	TQStringList keys;
	TQValueList<int> values;
};
class CardStack : public TQValueList<Card>
{
	public:
	CardStack() {}
	CardStack(const TQString &newName) { setName(newName); }
	const TQString &name() { return m_name; }
	void setName(const TQString &newName) { m_name = newName; }

	private:
	TQString m_name;
};

class EstateDlg : public TQWidget
{
	Q_OBJECT
  TQ_OBJECT

	public:
	EstateDlg(TQWidget *parent = 0, char *name = 0) : TQWidget(parent, name) { estate = 0; }

	signals:
	void updateBackground();

	public slots:
	virtual void slotOk() { save(); }
	void slotUpdate(ConfigEstate *newEstate) { estate = newEstate; if (estate) update(); }
	void groupsChanged() { groupUpdate(); }

	protected:
	virtual void update() {}
	virtual void save() {}
	virtual void groupUpdate() {}
	ConfigEstate *estate;
};

class EstateEdit : public TQWidget
{
	Q_OBJECT
  TQ_OBJECT

	public:
	EstateEdit(ConfigEstateGroupList *, EstateList *, TQValueList<CardStack> *, TQWidget *parent = 0, const char *name = 0);
	ConfigEstate *theEstate() { return estate; }
	bool upArrow()const;
	bool downArrow()const;
	bool leftArrow()const;
	bool rightArrow()const;
	void aboutToDie();
	void setReady(bool);

	public slots:
	void setEstate(ConfigEstate *);
	ConfigEstate *saveEstate(bool superficial = false);
	void groupsChanged();

	signals:
	void somethingChanged();
	void modified();
	void updateBackground();
	void goChecked(int id);
	void resized();

	protected:
    void resizeEvent(TQResizeEvent *);

	private slots:
	void configure();
	void goToggled(bool);

	private:
	KComboBox *typeCombo;
	TQLineEdit *nameEdit;
	TQCheckBox *goCheck;
	TQSpinBox *passMoney;
	TQWidget *centerWidget;
	TQGridLayout *tqlayout;

	EstateList *estates;
	TQValueList<CardStack> *cards;
	ConfigEstateGroupList *groups;

	ConfigEstate *estate;

	EstateDlg *confDlg;

	int oldType;

	bool ready;
	bool locked;
};

class ChooseWidget : public TQWidget
{
	Q_OBJECT
  TQ_OBJECT

	public:
	ChooseWidget(EstateList *, int id, Card *, TQWidget *parent = 0, char *name = 0);

	public slots:
	void typeChanged(int);
	void valueChanged(int);
	void estateChanged(int);

	private:
	Card *card;
	KComboBox *typeCombo;
	TQSpinBox *value;
	KComboBox *estate;
	bool number;
	bool prevNumber;
	bool init;
	TQHBoxLayout *htqlayout;

	EstateList *estates;

	int id;
};

class CardView : public TQWidget
{
	Q_OBJECT
  TQ_OBJECT

	public:
	CardView(EstateList *, CardStack *, TQWidget *parent = 0, char *name = 0);

	private slots:
	void selected(int);
	void add();
	void del();
	void rename();
	void more();
	void less();
	void updateButtonsEnabled();

	private:
	KListBox *List;
	KPushButton *addButton;
	KPushButton *renameButton;
	KPushButton *delButton;
	KPushButton *moreButton;
	KPushButton *lessButton;

	EstateList *estates;

	TQVBoxLayout *tqlayout;

	Card *card;

	CardStack *stack;
	TQPtrList<ChooseWidget> choosies;
};

class TaxDlg : public EstateDlg
{
	Q_OBJECT
  TQ_OBJECT

	public:
	TaxDlg(TQWidget *parent = 0, char *name = 0);

	protected:
	virtual void save();
	virtual void update();

	private:
	TQSpinBox *tax;
	TQSpinBox *taxPercentage;
};

class GenericDlg : public EstateDlg
{
	Q_OBJECT
  TQ_OBJECT

	public:
	GenericDlg(TQWidget *parent = 0, char *name = 0);

	protected:
	virtual void save();
	virtual void update();

	private:
	KColorButton *col;
};

class CardsDlg : public EstateDlg
{
	Q_OBJECT
  TQ_OBJECT

	public:
	CardsDlg(EstateList *, TQValueList<CardStack> *, TQWidget *parent = 0, char *name = 0);

	protected:
	virtual void save();
	virtual void update();

	private slots:
	void addStack();
	void updateView(const TQString &);

	private:
	TQValueList<CardStack> *stacks;
	EstateList *estates;

	TQComboBox *cards;
	CardView *view;
	TQVBoxLayout *vtqlayout;
};

class StreetDlg : public EstateDlg
{
	Q_OBJECT
  TQ_OBJECT

	public:
	StreetDlg(ConfigEstateGroupList *, TQWidget *parent = 0, char *name = 0);

	protected:
	virtual void save();
	virtual void update();
	virtual void groupUpdate();

	private slots:
	void groupChanged(const TQString &);

	private:
	TQSpinBox *houses0;
	TQSpinBox *houses1;
	TQSpinBox *houses2;
	TQSpinBox *houses3;
	TQSpinBox *houses4;
	TQSpinBox *houses5;
	TQSpinBox *price;
	KComboBox *groupCombo;

	ConfigEstateGroupList *groups;

	ConfigEstateGroup *curGroup();
};

#endif
