/*  This file is part of the KDE project
    Copyright (C) 2002 Matthias Kretz <kretz@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License version 2
    as published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/

/* $Id: kviewpresenter.h 1246260 2011-08-10 22:19:39Z tpearson $ */

#ifndef __kviewpresenter_h
#define __kviewpresenter_h

#include <kparts/plugin.h>
#include <kurl.h>

#include <tqsortedlist.h>

namespace KImageViewer { class Viewer; }

class ImageListDialog;
class ImageListItem;
class TQListViewItem;
class TQTimer;
class KToggleAction;
class KAction;

class KViewPresenter : public KParts::Plugin
{
	Q_OBJECT
  TQ_OBJECT
public:
	KViewPresenter( TQObject* parent, const char* name, const TQStringList & );
	virtual ~KViewPresenter();

protected:
	struct ImageInfo
	{
		KURL url;
		ImageInfo( const KURL & url )
			: url( url )
		{
		}
		bool operator==( const ImageInfo & i1 )
		{
			return url.prettyURL() == i1.url.prettyURL();
		}
		bool operator!=( const ImageInfo & i1 )
		{
			return url.prettyURL() == i1.url.prettyURL();
		}
		bool operator>( const ImageInfo & i1 )
		{
			return url.prettyURL() > i1.url.prettyURL();
		}
		bool operator<( const ImageInfo & i1 )
		{
			return url.prettyURL() < i1.url.prettyURL();
		}
	};
	bool eventFilter( TQObject *, TQEvent * );

private slots:
	void slotImageOpened( const KURL & );
	void slotImageList();
	void slotOpenFiles();
	void slotClose();
	void changeItem( TQListViewItem * );
	void prev();
	void next();
	void slideshow( bool );
	void setSlideshowInterval( int );
	void shuffle();
	void closeAll();
	void loadList();
	void saveList();

private:
	void makeCurrent( TQListViewItem * );

	KImageViewer::Viewer * m_pViewer;
	ImageListDialog * m_pImageList;
	KToggleAction * m_paSlideshow;
	KAction * m_paFileOpen;
	KAction * m_paFileClose;

	TQSortedList<ImageInfo> m_imagelist;
	bool m_bDontAdd;
	ImageListItem * m_pCurrentItem;
	TQTimer * m_pSlideshowTimer;
};

// vim:sw=4:ts=4:cindent
#endif
