//-*-C++-*-
/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2000-2001 by Leonardo Skorianez
    email                : lsk@if.ufrj.br
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#ifndef PMTQUICKCOLOREDIT_H
#define PMTQUICKCOLOREDIT_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kcolordialog.h>

#include "pmdialogeditbase.h"

class PMQuickColor;
class PMColorEdit;

/**
 * Dialog edit class for @ref PMQuickColor.
 */
class PMQuickColorEdit : public PMDialogEditBase
{
   Q_OBJECT
  TQ_OBJECT
   typedef PMDialogEditBase Base;
public:
   /**
    * Creates a PMQuickColorEdit with parent and name
    */
   PMQuickColorEdit( TQWidget* parent, const char* name = 0 );

   /** */
   virtual void displayObject( PMObject* o );

   /** */
   virtual bool isDataValid( );

protected:
   /** */
   virtual void createTopWidgets( );
   /** */
   virtual void saveContents( );

private:
   PMQuickColor* m_pDisplayedObject;
   PMColorEdit* m_pColorEdit;
};


#endif
