/***************************************************************************
 *   Copyright (C) 2004 by Robert Gruber                                   *
 *   rgruber@users.sourceforge.net                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kmessagebox.h>
#include <kcursor.h>
#include <klocale.h>
#include <kdebug.h>
#include <dcopref.h>

#include <tqtextbrowser.h>
#include <tqregexp.h>

#include "editorsdialog.h"

//dcop connection to cervisia
#include <cvsjob_stub.h>
#include <cvsservice_stub.h>

EditorsDialog::EditorsDialog(CvsService_stub *cvsService, TQWidget *parent, const char *name)
    : DCOPObject( "CvsEditorsDCOPIface"), EditorsDialogBase(parent, name, TRUE, TQt::WDestructiveClose),
      m_cvsService(cvsService), m_cvsJob(0)
{
}

EditorsDialog::~EditorsDialog()
{
    kdDebug(9006) << "EditorsDialog::~EditorsDialog"<< endl;

    if (m_cvsJob && m_cvsJob->isRunning()) {
        m_cvsJob->cancel();
    }
    if (m_cvsJob) 
        delete m_cvsJob;
}

void EditorsDialog::startjob(TQString strDir)
{
    kdDebug(9006) << "EditorsDialog::start() workDir = " << strDir << endl;

    DCOPRef job = m_cvsService->editors( strDir );
    m_cvsJob = new CvsJob_stub( job.app(), job.obj() );

    // establish connections to the signals of the cvs m_job
    connectDCOPSignal( job.app(), job.obj(), "jobExited(bool, int)", "slotJobExited(bool, int)", true );
    // We'll read the ouput directly from the job ...
    connectDCOPSignal( job.app(), job.obj(), "receivedStdout(TQString)", "slotReceivedOutput(TQString)", true );

    kdDebug(9006) << "Running: " << m_cvsJob->cvsCommand() << endl;
    m_cvsJob->execute();
}

void EditorsDialog::slotJobExited( bool normalExit, int exitStatus )
{
    if (!normalExit)
    {
        KMessageBox::sorry( this, i18n("Log failed with exitStatus == %1").tqarg( exitStatus), i18n("Log Failed") );
        return;
    }

    static TQRegExp re("([^\\s]+)\\s([^\\s]+)\\s([^\\s]+)\\s([^\\s]+)\\s([^\\s]+)\\s"
                        "([^\\s]+)\\s([^\\s]+)\\s([^\\s]+)\\s([^\\s]+)\\s(.*)");
    static TQRegExp subre("([^\\s]+)\\s([^\\s]+)\\s([^\\s]+)\\s([^\\s]+)\\s"
                        "([^\\s]+)\\s([^\\s]+)\\s([^\\s]+)\\s([^\\s]+)\\s(.*)");
	TQString lastfilename;

    TQStringList lines = TQStringList::split( "\n", m_output );
    int found = 0;
    for (size_t i=0; i<lines.count(); ++i) {
        TQString s = lines[i].simplifyWhiteSpace();
    	kdDebug(9006) << "editors:---" << s << "---" << endl;
    	kdDebug(9006) << "       : lastfile was " << lastfilename << endl;

        if (re.exactMatch(s)) {
            TQString file = re.cap( 1 );
            TQString locker = re.cap( 2 );
            TQString date = re.cap(5)+" "+re.cap(4)+" "+re.cap(7)+" "+re.cap(6);
            
            m_textBrowser->append( "<b>"+i18n("File")+": <code>"+file+"</code></b>" );
            m_textBrowser->append( "<b>"+i18n("User")+":</b> "+locker );
            m_textBrowser->append( "<b>"+i18n("Date")+":</b> "+date );
            m_textBrowser->append( "<hr>" );
            found++;

            lastfilename = file;
        } else {
	        if (subre.exactMatch(s)) {
				TQString file = lastfilename;
				TQString locker = subre.cap( 1 );
				TQString date = subre.cap(4)+" "+subre.cap(3)+" "+subre.cap(6)+" "+subre.cap(5);
				
				m_textBrowser->append( "<b>"+i18n("File")+": <code>"+file+"</code></b>" );
				m_textBrowser->append( "<b>"+i18n("User")+":</b> "+locker );
				m_textBrowser->append( "<b>"+i18n("Date")+":</b> "+date );
				m_textBrowser->append( "<hr>" );
				found++;
 			}
    	}
	}

    if (!found)
        m_textBrowser->append(i18n("No files from your query are marked as being edited."));

    m_textBrowser->source();

    if (m_cvsJob) {
        disconnectDCOPSignal( m_cvsJob->app(), m_cvsJob->obj(), "jobExited(bool, int)", "slotJobExited(bool, int)" );
        delete m_cvsJob;
        m_cvsJob=NULL;
    }
}

void EditorsDialog::slotReceivedOutput( TQString someOutput )
{
    kdDebug(9006) << "OUTPUT: " << someOutput << endl;

    m_output += someOutput; //append the whole output into one large TQStrin
}

///////////////////////////////////////////////////////////////////////////////

void EditorsDialog::slotReceivedErrors( TQString someErrors )
{
    kdDebug(9006) << "ERRORS: " << someErrors << endl;
}

#include "editorsdialog.moc"
