/***************************************************************************
 *   Copyright (C) 2003 by Mario Scalas                                    *
 *   mario.scalas@libero.it                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CVSDIR_H
#define CVSDIR_H

#include <tqdir.h>
#include <tqstringlist.h>
#include <tqmap.h>

#include "cvsentry.h"

/**
Helper classes for handling CVS dirs

@author Mario Scalas
*/
class CVSDir : public TQDir
{
public:
    CVSDir();
    CVSDir( const TQDir &dir );
    explicit CVSDir( const CVSDir & );
    CVSDir &operator=( const CVSDir & );
    virtual ~CVSDir();

    /**
    * A client can use this method to validate the directory state.
    * @return true if the directory is a valid CVS dir, false otherwise
    */
    bool isValid() const;
    /**
    * Returns a list of all the files registered into repository
    */
    TQStringList registeredEntryList() const;
    /**
    * @param fileName is the file name (with no path info, just the file name!)
    * @param refreshCache update internal cache re-parsing "<dirPath>/CVS/Entries"
    * @return an empty CVSEntry if the file is not present
    */
    CVSEntry filetqStatus( const TQString &fileName, bool refreshCache = false ) const;
    /**
    */
    VCSFileInfoMap dirtqStatus() const;
    VCSFileInfoMap *cacheableDirtqStatus() const;
    /**
    * @return true if the file is registered into repository, false otherwise
    */
    bool isRegistered( const TQString fileName ) const;
    /**
    * Check if the specified @p fileName is in "<CVSDIR>/.cvsignore" and, if not,
    * append it.
    */
    void ignoreFile( const TQString &fileName );
    /**
    * Check if the specified @p fileName is in "<CVSDIR>/.cvsignore" and, if yes,
    * remove it.
    */
    void doNotIgnoreFile( const TQString &fileName );
    /**
    * @return the content of "<CVSDIR>/CVS/Repository"
    */
    TQString repository() const;
    /**
    * @return the content of "<CVSDIR>/CVS/Root"
    */
    TQString root() const;
    /**
    * @return full path of "<this-dir>/CVS/Entries"
    */
    TQString entriesFileName() const;
    /**
    * @return full path of "<this-dir>/CVS/Root"
    */
    TQString rootFileName() const;
    /**
    * @return full path of "<this-dir>/CVS/Repository"
    */
    TQString repoFileName() const;
    /**
    * @return full path of "<this-dir>/.cvsignore"
    */
    TQString cvsIgnoreFileName() const;

private:
    void refreshEntriesCache() const;
    static TQByteArray cacheFile( const TQString &fileName );

    TQString m_cvsDir;

    typedef TQMap<TQString,CVSEntry> CVSEntriesCacheMap;
    mutable CVSEntriesCacheMap m_cachedEntries;
};

#endif
