/***************************************************************************
 *   Copyright (C) 2003 by Mario Scalas                                    *
 *   mario.scalas@libero.it                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tqdatetime.h>
#include <tqfile.h>
#include <tqtextstream.h>

#include <kemailsettings.h>

#include "changelog.h"

ChangeLogEntry::ChangeLogEntry()
{
    KEMailSettings emailConfig;
    emailConfig.setProfile( emailConfig.defaultProfileName() );
    authorEmail = emailConfig.getSetting( KEMailSettings::EmailAddress );
    authorName = emailConfig.getSetting( KEMailSettings::RealName );

    TQDate currDate = TQDate::tqcurrentDate();
    date = currDate.toString( "yyyy-MM-dd" );
}

ChangeLogEntry::~ChangeLogEntry()
{
}

void ChangeLogEntry::addLine( const TQString &aLine )
{
    lines << aLine;
}

void ChangeLogEntry::addLines( const TQStringList &someLines )
{
    lines += someLines;
}

void streamCopy( TQTextStream &is, TQTextStream &os )
{
    while (!is.eof())
        os << is.readLine() << "\n";  // readLine() eats '\n' !!
}

void ChangeLogEntry::addToLog( const TQString &logFilePath, const bool prepend, const TQString &startLineString )
{
    if (prepend) // add on head
    {
        TQString fakeLogFilePath = logFilePath + ".fake";

        TQFile fakeFile( fakeLogFilePath );
        TQFile changeLogFile( logFilePath );
        {
            if (!fakeFile.open( IO_WriteOnly | IO_Append))
                return;

            if (changeLogFile.open( IO_ReadOnly )) // A Changelog already exist
            {
                TQTextStream is( &changeLogFile );
                TQTextStream os( &fakeFile );

                // Put current entry
                os << toString( startLineString );
                // Write the rest of the change log file
                streamCopy( is, os );
            }
            else // ChangeLog doesn't exist: just write our entry
            {
                TQTextStream t( &fakeFile );
                t << toString( startLineString );
            }
            fakeFile.close();
            changeLogFile.close();
        }
        // Ok, now we have the change log we need in fakeLogFilePath: we should ask for a
        // 'mv fakeLogFilePath logFilePath'-like command ... :-/
        if (!fakeFile.open( IO_ReadOnly ))
            return;

        if (changeLogFile.open( IO_WriteOnly ))
        {
            TQTextStream os( &changeLogFile );
            TQTextStream is( &fakeFile );

            // Write the rest of the change log file
            streamCopy( is, os );
        }
        fakeFile.close();
        fakeFile.remove(); // fake changelog is no more needed!
        changeLogFile.close();
    }
    else // add on tail
    {
        TQFile f( logFilePath );
        if (!f.open( IO_WriteOnly | IO_Append))
            return;

        TQTextStream t( &f );
        t << toString( startLineString );
    }
}

TQString ChangeLogEntry::toString( const TQString &startLineString ) const
{
    TQString header = date + " " + authorName + " <" + authorEmail + ">\n";

    return header + startLineString + lines.join( "\n" + startLineString ) + "\n\n";
}
