
#include "splashscreen.h"
#include "splashscreen.moc"

#include <config.h>

#include <tqtimer.h>
#include <tqfont.h>

#include <klocale.h>
#include <kglobalsettings.h>

KDevSplashScreen::KDevSplashScreen(const TQPixmap& pixmap, WFlags f) : TQSplashScreen(pixmap, f)
{
	TQTimer *timer = new TQTimer( this );
	TQObject::connect(timer, TQT_SIGNAL(timeout()), this, TQT_SLOT(animate()));
    timer->start(150);

	state = 0;
	progress_bar_size = 3;
}


KDevSplashScreen::~KDevSplashScreen()
{
}


void KDevSplashScreen::animate()
{
	state = ((state + 1) % (2*progress_bar_size-1));
	tqrepaint();
}


void KDevSplashScreen::message( const TQString &str, int flags, const TQColor &color)
{
	TQSplashScreen::message(str,flags,color);
	animate();
	m_string = str;
}


void KDevSplashScreen::drawContents (TQPainter* painter)
{
	int position;
	TQColor base_color (201,229,165); // Base green color

	// Draw background circles
	painter->setPen(NoPen);
	painter->setBrush(TQColor(215,234,181));
	painter->drawEllipse(51,7,9,9);
	painter->drawEllipse(62,7,9,9);
	painter->drawEllipse(73,7,9,9);

	// Draw animated circles, increments are chosen
	// to get close to background's color
	// (didn't work well with TQColor::light function)
	for (int i=0; i < progress_bar_size; i++)
	{
		position = (state+i)%(2*progress_bar_size-1);
		painter->setBrush(TQColor(base_color.red()-18*i,
								 base_color.green()-10*i,
								 base_color.blue()-28*i));

		if (position < 3) painter->drawEllipse(51+position*11,7,9,9);
	}

	painter->setPen(TQColor(74,112,18));
	TQFont fnt(KGlobalSettings::generalFont());
	fnt.setPointSize(8);
	painter->setFont(fnt);

	// Draw version number
	TQRect r = rect();
    r.setRect(r.x() + 5, r.y() + 5, r.width() - 10, r.height() - 10);
    painter->drawText(r, TQt::AlignRight, i18n("Version %1").tqarg( VERSION ));

	// Draw message at given position, limited to 43 chars
	// If message is too long, string is truncated
	if (m_string.length() > 40) {m_string.truncate(39); m_string += "...";}
	painter->drawText (90, 16, m_string, 42);

}

