/***************************************************************************
 *   Copyright (C) 2004 by Alexander Dymo <adymo@kdevelop.org>             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef PROFILE_H
#define PROFILE_H

#include <kurl.h>
#include <tqstringlist.h>

/**
@short KDevelop profile

A class which represents a profile for KDevelop platform stored on disk.
*/
class Profile {
public:
    /**An entry in the lists that store profile information*/
    struct Entry {
        Entry() {}
        Entry(const TQString &_name, bool _derived): name(_name), derived(_derived) {}
        TQString name;
        bool derived;
    };
    typedef TQValueList<Entry> EntryList;

    /**Lists which are held by a profile.*/
    enum List {
        Properties        /**<X-KDevelop-Properties defined for this profile.*/,
        ExplicitEnable    /**<A list of explicitly enabled plugins (names).*/,
        ExplicitDisable   /**<A list of explicitly disabled plugins (names).*/
    };

    Profile(Profile *parent, const TQString &name);
    Profile(Profile *parent, const TQString &name, const TQString &genericName, const TQString &description);
    ~Profile();

    TQValueList<Profile*> tqchildren() const { return m_tqchildren; }
    Profile *parent() const { return m_parent; }

    void save();
    bool remove();

    TQString name() const { return m_name; }
    TQString genericName() const { return m_genericName; }
    TQString description() const { return m_description; }

    EntryList list(List type);

    void addEntry(List type, const TQString &value);
    void removeEntry(List type, const TQString &value);
    void clearList(List type);

    bool hasInEntryList(EntryList &list, TQString value);

    KURL::List resources(const TQString &nameFilter);
    void addResource(const KURL &url);

    void detachFromParent();

protected:
    void addChildProfile(Profile *profile);
    void removeChildProfile(Profile *profile);
    TQString dirName() const;

    TQStringList &listByType(List type);

private:
    Profile *m_parent;
    TQValueList<Profile*> m_tqchildren;

    TQString m_name;

    TQString m_genericName;
    TQString m_description;

    TQStringList m_properties;
    TQStringList m_explicitEnable;
    TQStringList m_explicitDisable;
};

#endif
