/*
 *  File : snippet_widget.h
 *
 *  Author: Robert Gruber <rgruber@users.sourceforge.net>
 *
 *  Copyright: See COPYING file that comes with this distribution
 */

#ifndef __SNIPPET_WIDGET_H__
#define __SNIPPET_WIDGET_H__

#include <tqwidget.h>
#include <tqstring.h>
#include <klistview.h>
#include <tqtooltip.h>
#include <tqrect.h>

#include <ktexteditor/editinterface.h>
#include <ktexteditor/view.h>
#include "snippetconfig.h"

class KDevProject;
class SnippetPart;
class TQPushButton;
class KListView;
class TQListViewItem;
class TQPoint;
class SnippetDlg;
class SnippetItem;
class KTextEdit;
class KConfig;


/**
This is the widget which gets added to the right TreeToolView.
It inherits KListView and TQToolTip which is needed for showing the
tooltips which contains the text of the snippet
@author Robert Gruber
*/
class SnippetWidget : public KListView, public TQToolTip
{
  Q_OBJECT
  TQ_OBJECT

  friend class SnippetSettings; //to allow SnippetSettings to call languageChanged()
  
public:
    SnippetWidget(SnippetPart *part);
    ~SnippetWidget();
    TQPtrList<SnippetItem> * getList() { return (&_list); }
    void writeConfig();
    void initConfigOldVersion(KConfig *cfg);
    SnippetConfig *  getSnippetConfig() { return (&_SnippetConfig); }


private slots:
    void initConfig();
    void languageChanged();

protected:
    SnippetPart * m_part;
    void maybeTip( const TQPoint & );
    bool acceptDrag (TQDropEvent *event) const;

private:
    void insertIntoActiveView(TQString text);
    TQString parseText(TQString text, TQString del="$");
    bool showMultiVarDialog(TQMap<TQString, TQString> * map, TQMap<TQString, TQString> * mapSave,
                            int & iWidth, int & iBasicHeight, int & iOneHeight);
    TQString showSingleVarDialog(TQString var, TQMap<TQString, TQString> * mapSave, TQRect & dlgSize);

    TQPtrList<SnippetItem> _list;
    TQMap<TQString, TQString> _mapSaved;
    KConfig * _cfg;
    SnippetConfig _SnippetConfig;

public slots:
    void slotRemove();
    void slotEdit();
    void slotEditGroup();
    void slotAdd();
    void slotAddGroup();

protected slots:
    void showPopupMenu( TQListViewItem * item, const TQPoint & p, int );
    void slotExecuted(TQListViewItem * item);
    void slotDropped(TQDropEvent *e, TQListViewItem *after);
};


#endif
