/***************************************************************************
 *   Copyright (C) 2003 by Jens Dagerbo                                    *
 *   jens.dagerbo@swipnet.se                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tqpainter.h>
#include <tqstyle.h>
#include <tqpalette.h>
#include <tqcheckbox.h>

#include "replaceitem.h"

bool ReplaceItem::s_listview_done = false;


bool ReplaceItem::hasCheckedChildren() const
{
    ReplaceItem const * item = firstChild();
    while ( item )
    {
        if ( item->isOn() )
        {
            return true;
        }
        item = item->nextSibling();
    }
    return false;
}

void ReplaceItem::stateChange( bool state )
{
    if ( s_listview_done && justClicked() )
    {
        setChecked( state );
    }
}

void ReplaceItem::setChecked( bool checked )
{
    if ( !isFile() )	// this is a child item
    {
        if ( checked || !(parent()->hasCheckedChildren()))
        {
            if ( parent()->isOn() != checked )
            {
                parent()->_clicked = false;
                parent()->setOn( checked );
            }
        }
        return;
    }

    // this is a parent item, set self and tqchildren
    ReplaceItem * item = firstChild();
    while ( item )
    {
        if ( item->isOn() != checked )
        {
            item->_clicked = false;
            item->setOn( checked );
        }
        item = item->nextSibling();
    }
}

// code mostly lifted from TQCheckListItem::paintCell()
void ReplaceItem::paintCell( TQPainter * p, const TQColorGroup & cg, int column, int width, int align )
{
    if ( !p )
        return;

    TQListView *lvv = listView();
    if ( !lvv )
        return;

    ReplaceView * lv = static_cast<ReplaceView*>(lvv);

    const BackgroundMode bgmode = lv->viewport()->backgroundMode();
    const TQColorGroup::ColorRole crole = TQPalette::backgroundRoleFromMode( bgmode );

    if ( cg.brush( crole ) != lv->tqcolorGroup().brush( crole ) )
        p->fillRect( 0, 0, width, height(), cg.brush( crole ) );
    else
        lv->paintEmptyArea( p, TQRect( 0, 0, width, height() ) );

    TQFontMetrics fm( lv->fontMetrics() );
    int boxsize = lv->tqstyle().tqpixelMetric(TQStyle::PM_CheckListButtonSize, lv);
    int marg = lv->itemMargin();
    int r = marg;

    // Draw controller / checkbox / radiobutton ---------------------
    int styleflags = TQStyle::Style_Default;
    if ( isOn() )
        styleflags |= TQStyle::Style_On;
    else
        styleflags |= TQStyle::Style_Off;
    if ( isSelected() )
        styleflags |= TQStyle::Style_Selected;
    if ( isEnabled() && lv->isEnabled() )
        styleflags |= TQStyle::Style_Enabled;

    int x = 0;
    int y = 0;

    x += 3;

    if ( align & AlignVCenter )
        y = ( ( height() - boxsize ) / 2 ) + marg;

    else
        y = (fm.height() + 2 + marg - boxsize) / 2;

    lv->tqstyle().tqdrawPrimitive(TQStyle::PE_CheckListIndicator, p,
                              TQRect(x, y, boxsize,
                                    fm.height() + 2 + marg),
                              cg, styleflags, TQStyleOption(this));

    r += boxsize + 4;

    // Draw text ----------------------------------------------------
    p->translate( r, 0 );
    p->setPen( TQPen( cg.text() ) );

    TQColorGroup mcg = cg;
    mcg.setColor( TQColorGroup::Text, ( isFile() ? TQt::darkGreen : TQt::blue ) );
    mcg.setColor( TQColorGroup::HighlightedText, ( isFile() ? TQt::darkGreen : TQt::blue ) );

    TQListViewItem::paintCell( p, mcg, column, width - r, align );
}

void ReplaceItem::activate( int, TQPoint const & localPos )
{
    TQListView * lv = listView();
    TQCheckBox cb(0);
    int boxsize = cb.tqsizeHint().width();
//that's KDE-3.1 only    int boxsize = lv->style().tqpixelMetric(TQStyle::PM_CheckListButtonSize, lv);
    int rightside = lv->itemMargin() + boxsize + ( isFile() ? 0 : lv->treeStepSize() );

    // _lineclicked indicates if the click was on the line or in the checkbox
    _lineclicked = rightside < localPos.x();
}
