/***************************************************************************
 *   Copyright (C) 2002 by Bernd Gehrmann                                  *
 *   bernd@kdevelop.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "shellinsertdlg.h"

#include <tqcombobox.h>
#include <tqlayout.h>
#include <tqpushbutton.h>
#include <kconfig.h>
#include <kbuttonbox.h>
#include <kdebug.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kprocess.h>
#include <klineedit.h>
#include <kstdguiitem.h>
#include <kdeversion.h>

#include "kdevplugin.h"
#include "domutil.h"
#include "filterpart.h"


ShellInsertDialog::ShellInsertDialog()
    : TQDialog(0, "shell filter dialog", true)
{
    TQVBoxLayout *tqlayout = new TQVBoxLayout(this, 10, 4);

    combo = new TQComboBox(true, this);
    combo->setDuplicatesEnabled(false);
    tqlayout->addWidget(combo);

    KButtonBox *buttonbox = new KButtonBox(this);
    start_button = buttonbox->addButton(i18n("&Start"));
    start_button->setDefault(true);
    cancel_button = buttonbox->addButton(KStdGuiItem::cancel());
    buttonbox->tqlayout();
    tqlayout->addWidget(buttonbox);

    connect( start_button, TQT_SIGNAL(clicked()),
             this, TQT_SLOT(slotStartClicked()) );
    connect( cancel_button, TQT_SIGNAL(clicked()),
             this, TQT_SLOT(reject()) );
    connect( combo->lineEdit(), TQT_SIGNAL(textChanged( const TQString &)), this, TQT_SLOT(executeTextChanged( const TQString &)));
    m_proc = 0;

    KConfig *config = FilterFactory::instance()->config();
    config->setGroup("General");
    TQStringList items = config->readListEntry("InsertItems");
    combo->insertStringList(items);
    executeTextChanged( combo->lineEdit()->text());

}


ShellInsertDialog::~ShellInsertDialog()
{
    kdDebug(9029) << "~ShellInsertDialog" << endl;
    delete m_proc;

    // TQComboBox API is a bit incomplete :-(
    TQStringList list;
    for (int i=0; i < combo->count(); ++i)
        list << combo->text(i);

    KConfig *config = FilterFactory::instance()->config();
    config->setGroup("General");
    config->writeEntry("InsertItems", list);
}


void ShellInsertDialog::executeTextChanged( const TQString &text)
{
    start_button->setEnabled(!text.isEmpty());
}

int ShellInsertDialog::exec()
{
    start_button->setEnabled(true);
    return TQDialog::exec();
}


void ShellInsertDialog::slotStartClicked()
{
    start_button->setEnabled(false);
    m_str = TQCString();

    delete m_proc;
    m_proc = new KShellProcess("/bin/sh");
    (*m_proc) << combo->currentText();
    connect( m_proc, TQT_SIGNAL(receivedStdout(KProcess*, char *, int)),
             this, TQT_SLOT(slotReceivedStdout(KProcess*, char *, int)) );
    connect( m_proc, TQT_SIGNAL(processExited(KProcess*)),
             this, TQT_SLOT(slotProcessExited(KProcess*)) );
    m_proc->start(KProcess::NotifyOnExit, KProcess::AllOutput);
}


void ShellInsertDialog::slotReceivedStdout(KProcess *, char *text, int len)
{
    m_str += TQCString(text, len+1);
}


void ShellInsertDialog::slotProcessExited(KProcess *)
{
    if (m_proc->normalExit()) {
        accept();
    } else {
        KMessageBox::error(this, i18n("Process exited with status %1")
                           .tqarg(m_proc->exitStatus()));
        reject();
    }
}

#include "shellinsertdlg.moc"
