/***************************************************************************
 *   Copyright (C) 2003 by Julian Rockey                                   *
 *   linux@jrockey.com                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "filecreate_newfile.h"

#include "filecreate_newfile.moc"

#include <tqvbox.h>
#include <tqgrid.h>

#include <tqhbox.h>
#include <tqlayout.h>
#include <tqcheckbox.h>
#include <tqlabel.h>
#include <klineedit.h>
#include <kurlrequester.h>
#include <kcombobox.h>
#include <klocale.h>
#include <kdebug.h>
#include <kmessagebox.h>


namespace FileCreate {

  NewFileChooser::NewFileChooser(TQWidget * parent) :
    KDialogBase(KDialogBase::Plain, i18n("New file dialog (title)", "New File"), KDialogBase::Ok|KDialogBase::Cancel,
                KDialogBase::Ok, parent, "New file", true)
  {
      TQVBoxLayout* lay = new TQVBoxLayout( plainPage(), 5, 5 );

      lay->addWidget( new TQLabel( i18n("<b>New File Creation</b>"), plainPage() ) );

      TQGridLayout* grid = new TQGridLayout(lay, 2, 2, 5 );
      TQLabel * l = new TQLabel(i18n("&Directory:"), plainPage() );
      grid->addWidget(l, 0, 0);
      m_urlreq = new KURLRequester( plainPage(), "url request" );
      grid->addWidget(m_urlreq, 0, 1);
      l->setBuddy(m_urlreq);
      l = new TQLabel(i18n("&File name:"), plainPage() );
      grid->addWidget(l, 1, 0);
      m_filename = new KLineEdit( plainPage() );
      grid->addWidget(m_filename, 1, 1);
      l->setBuddy(m_filename);
//      lay->addWidget( grid );

      TQHBoxLayout* hbox = new TQHBoxLayout( lay, 5 );
      m_filetypes = new KComboBox( plainPage(), "combo" );
      hbox->addWidget(m_filetypes);
      m_addToProject = new TQCheckBox( i18n("Add to project (on checkbox)", "&Add to project"), plainPage(), "addproject" );
      hbox->addWidget(m_addToProject);

      lay->addStretch(20);

      m_filename->setFocus();
      m_addToProject->setChecked( true );

      m_urlreq->setMode((int) KFile::Directory);
      connect( m_filename,  TQT_SIGNAL( textChanged ( const TQString & ) ), this, TQT_SLOT( slotFileNameChanged(const TQString & ) ) );
      slotFileNameChanged( m_filename->text() );
  }

  NewFileChooser::~NewFileChooser() {
  }

    void NewFileChooser::slotFileNameChanged(const TQString & _text)
    {
        enableButtonOK( !_text.isEmpty() );
    }

  void NewFileChooser::setFileTypes(TQPtrList<FileType> filetypes) {
    for(FileType * filetype = filetypes.first();
	filetype;
	filetype=filetypes.next()) {

      if (filetype->enabled()) {

	if (filetype->subtypes().count()==0)
          addType(filetype);

	TQPtrList<FileType> subtypes = filetype->subtypes();
	for(FileType * subtype = subtypes.first();
	    subtype;
	    subtype=subtypes.next()) {
	  if (subtype->enabled())
            addType(subtype);

	}

      }

    }

  }

  KURL NewFileChooser::url() const {

    KURL result ( m_urlreq->url() );
    result.cd( m_filename->text() );
    return result;
  }

  bool NewFileChooser::addToProject() const {
    return m_addToProject->isChecked();
  }

  const FileType *NewFileChooser::selectedType() const {
    if (!m_filetypes->count()) return NULL;
    return m_typeInCombo[m_filetypes->currentItem()];
  }

  void NewFileChooser::addType(const FileType * filetype) {
    m_typeInCombo[m_filetypes->count()]=filetype;
    m_filetypes->insertItem( filetype->name() +
                             (filetype->ext()!="" ? TQString(" (." + filetype->ext() + ")") : TQString("") ) );
  }

  void NewFileChooser::setCurrent(const FileType *filetype) {
    int changeToRow = -1;
    TQMap<int,const FileType*>::Iterator it;
    for ( it = m_typeInCombo.begin(); it != m_typeInCombo.end() && changeToRow==-1; ++it ) {
      if (it.data()==filetype)
        changeToRow=it.key();
    }
    if (changeToRow>-1) m_filetypes->setCurrentItem(changeToRow);
  }

  void NewFileChooser::setDirectory(const TQString & url) {
    m_urlreq->setURL(url);
  }

  void NewFileChooser::setName(const TQString & name) {
    m_filename->setText(name);
  }

  void NewFileChooser::setInProjectMode( bool m )
  {
    m_addToProject->setEnabled(m);
    m_addToProject->setChecked(m);
  }

	void NewFileChooser::accept()
	{
		TQString fullPath = url().path();
		if ( !selectedType()->ext().isEmpty() && !fullPath.endsWith("." + selectedType()->ext())) fullPath+="." + selectedType()->ext();
		TQFileInfo file( fullPath );
		if ( file.exists() )
		{
			KMessageBox::sorry( this, i18n("A file with this name already exists"), i18n("File Exists") );
			return;
		}
		KDialogBase::accept();
	}

}

