/***************************************************************************
 *   Copyright (C) 2000 by Dimitri van Heesch                              *
 *   dimitri@stack.nl                                                      *
 *   Copyright (C) 2001 by Bernd Gehrmann                                  *
 *   bernd@kdevelop.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _DOXYGENCONFIGWIDGET_H_
#define _DOXYGENCONFIGWIDGET_H_

#include <tqtabwidget.h>
#include <tqdict.h>
#include <tqptrlist.h>

class IInput;


class DoxygenConfigWidget : public TQTabWidget
{
    Q_OBJECT
  TQ_OBJECT
    
public:
    DoxygenConfigWidget( const TQString &fileName, TQWidget *parent=0, const char *name=0 );
    ~DoxygenConfigWidget();

public slots:
    void accept();

private slots:
    void toggle(const TQString&, bool);
    void changed();

private:
    TQSize tqsizeHint() const;
    void loadFile();
    void saveFile();
    void init();
    void addDependency(TQDict<TQObject> *switches,
                       const TQCString &dep, const TQCString &name);

    TQString m_fileName;
    bool m_hasChanged;
    TQDict<IInput> *m_inputWidgets;
    TQDict< TQPtrList<IInput> > *m_dependencies;
    TQDict<TQObject> *m_switches;
};

#endif
