/***************************************************************************
 *   Copyright (C) 2004 by Alexander Dymo                                  *
 *   cloudtemple@mksat.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef DOCDEVHELPPLUGIN_H
#define DOCDEVHELPPLUGIN_H

#include <tqvaluestack.h>
#include <tqdom.h>

#include <kdevdocumentationplugin.h>

class DocDevHelpPlugin: public DocumentationPlugin
{
    Q_OBJECT
  TQ_OBJECT
public:
    DocDevHelpPlugin(TQObject* parent, const char* name, const TQStringList args = TQStringList());
    ~DocDevHelpPlugin();

    virtual TQString pluginName() const;

    virtual TQString catalogTitle(const TQString& url);
    virtual void setCatalogURL(DocumentationCatalogItem* item);
    
    virtual void createTOC(DocumentationCatalogItem* item);
    
    virtual DocumentationCatalogItem* createCatalog(KListView* contents, const TQString& title, const TQString& url);

    virtual bool needRefreshIndex(DocumentationCatalogItem* item);
    virtual void createIndex(IndexBox* index, DocumentationCatalogItem* item);
        
    virtual TQStringList fullTextSearchLocations();
    virtual void autoSetupPlugin();
    
    virtual TQPair<KFile::Mode, TQString> catalogLocatorProps();

    virtual ProjectDocumentationPlugin *projectDocumentationPlugin(ProjectDocType type);
        
protected:
    void pushToScanStack(TQValueStack<TQString> &stack, const TQString &value);
    void scanDevHelpDir(const TQString &path);
    void addTocSect(DocumentationItem *parent, TQDomElement childEl, TQString baseUrl, bool book=false);
};

#endif
