/* This file is part of the KDE project
   Copyright (C) 2004 Sascha Cunz <sascha@sacu.de>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/
#include "kdevlicense.h"

#include <tqfile.h>
#include <tqdatetime.h>
#include <tqregexp.h>

KDevLicense::KDevLicense( const TQString& name, const TQString& fileName )
	: m_name( name )
{
	readFile( fileName );
}

void KDevLicense::readFile( const TQString& fileName )
{
	TQFile f(fileName);
	if (!f.open(IO_ReadOnly))
		return;
	TQTextStream stream(&f);
	TQString str;
	enum { readingText, readingFiles } mode = readingText;
	for(;;)
	{
		str = stream.readLine();
		if( str.isNull() )
			break;
		if( str == "[FILES]" )
			mode = readingFiles;
		else if( str == "[PREFIX]" )
			mode = readingText;
		else if( mode == readingFiles )
		{
			if( !str.isEmpty() )
			{
				m_copyFiles.append( str );
			}
		} else
		m_rawLines.append( str );
	}

}

TQString KDevLicense::assemble( KDevFile::CommentingStyle commentingStyle, const TQString& author, const TQString& email, int leadingSpaces )
{
	// first, build a CPP Style license
	
	TQString strFill;
	strFill.fill( ' ', leadingSpaces );
	
	TQString str = 
		strFill + "/***************************************************************************\n" +
		strFill + " *   Copyright (C) $YEAR$ by $AUTHOR$   *\n" +
		strFill + " *   $EMAIL$   *\n" +
		strFill + " *                                                                         *\n";
	
//	str = str.tqarg(TQDate::tqcurrentDate().year()).tqarg(author.left(45),-45).tqarg(email.left(67),-67);
	
	TQStringList::Iterator it;
	for( it = m_rawLines.begin(); it != m_rawLines.end(); ++it )
	{
		str += TQString( "%1 *   %2 *\n").tqarg( strFill ).tqarg( *it, -69 );
	}
	
	str += strFill + " ***************************************************************************/\n";

	switch( commentingStyle )
	{
		case KDevFile::CPPStyle:
		case KDevFile::CStyle:
			return str;
			
		case KDevFile::PascalStyle:
			str.replace(TQRegExp("/\\**\n \\*"), "{\n  ");
			str.replace(TQRegExp("\\*\n \\*"), " \n  ");
			str.replace(TQRegExp(" *\\**/\n"), "}\n");
			return str;
			
		case KDevFile::AdaStyle:
			str.replace(TQRegExp("/\\*"), "--");
			str.replace(TQRegExp(" \\*"), "--");
			str.replace(TQRegExp("\\*/"), "*");
			return str;
			
		case KDevFile::BashStyle:
			str.replace(TQRegExp("\\*|/"), "#");
			str.replace(TQRegExp("\n ##"), "\n##");
			str.replace(TQRegExp("\n #"), "\n# ");
			return str;

		case KDevFile::XMLStyle:
			str.replace(TQRegExp("/\\*"), "<!--");
			str.replace(TQRegExp("\n \\*"), "\n<!--");
			str.replace(TQRegExp("\\*/?\n"), "-->\n");
			str.replace(TQRegExp("\\*"), "_");
			return str;
	}

	return "currently unknown/unsupported commenting style";
}
