/***************************************************************************
 *   Copyright (C) 2004 by Alexander Dymo                                  *
 *   cloudtemple@mskat.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#include "pyesnobutton.h"

#include <tqlayout.h>
#include <tqpainter.h>
#include <tqpushbutton.h>

#ifndef PURE_QT
#include <klocale.h>
#else
#include "compat_tools.h"
#endif

namespace PropertyLib{

PYesNoButton::PYesNoButton(MultiProperty* property, TQWidget* parent, const char* name)
    :PropertyWidget(property, parent, name)
{
    TQHBoxLayout *l = new TQHBoxLayout(this, 0, 0);
    m_edit = new TQPushButton(this);
    m_edit->setToggleButton(true);
    m_edit->tqsetSizePolicy(TQSizePolicy::MinimumExpanding, TQSizePolicy::MinimumExpanding);
    l->addWidget(m_edit);

    connect(m_edit, TQT_SIGNAL(toggled(bool)), this, TQT_SLOT(updateProperty(bool)));
}

TQVariant PYesNoButton::value() const
{
    return TQVariant(m_edit->isOn());
}

void PYesNoButton::drawViewer(TQPainter* p, const TQColorGroup& cg, const TQRect& r, const TQVariant& value)
{
    PropertyWidget::drawViewer(p, cg, r, value.toBool() ? i18n("Yes") : i18n("No"));
}

void PYesNoButton::setValue(const TQVariant& value, bool emitChange)
{
    disconnect(m_edit, TQT_SIGNAL(toggled(bool)), this, TQT_SLOT(updateProperty(bool)));
    m_edit->setDown(value.toBool());
    value.toBool() ? m_edit->setText(i18n("Yes")) : m_edit->setText(i18n("No"));
    connect(m_edit, TQT_SIGNAL(toggled(bool)), this, TQT_SLOT(updateProperty(bool)));
    if (emitChange)
        emit propertyChanged(m_property, value);
}

void PYesNoButton::updateProperty(bool toggled)
{
    toggled ? m_edit->setText(i18n("Yes")) : m_edit->setText(i18n("No"));
    emit propertyChanged(m_property, value());
}

}

#ifndef PURE_QT
#include "pyesnobutton.moc"
#endif
