/***************************************************************************
 *   Copyright (C) 2002-2004 by Alexander Dymo                             *
 *   cloudtemple@mskat.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef PSYMBOLCOMBO_H
#define PSYMBOLCOMBO_H

#include "propertywidget.h"

class KLineEdit;
class TQPushButton;
class TQHBoxLayout;

namespace PropertyLib{


/**
@short %Property editor with char selector.
*/
class PSymbolCombo: public PropertyWidget{
    Q_OBJECT
  TQ_OBJECT
public:
    PSymbolCombo(MultiProperty *property, TQWidget *parent = 0, const char *name = 0);

    /**@return the value currently entered in the editor widget.*/
    virtual TQVariant value() const;
    /**Sets the value shown in the editor widget. Set emitChange to false
    if you don't want to emit propertyChanged signal.*/
    virtual void setValue(const TQVariant &value, bool emitChange=true);
    /**Function to draw a property viewer when the editor isn't shown.*/
    virtual void drawViewer(TQPainter *p, const TQColorGroup &cg, const TQRect &r, const TQVariant &value);

public slots:
    void selectChar();

private slots:
    void updateProperty(const TQString &val);

private:
    KLineEdit *m_edit;
    TQPushButton *m_select;
    TQHBoxLayout *l;
};

}

#endif
