/***************************************************************************
 *   Copyright (C) 2002-2004 by Alexander Dymo                             *
 *   cloudtemple@mskat.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#include "pfontcombo.h"

#ifndef PURE_QT
#include <kfontcombo.h>
#else
#include <tqcombobox.h>
#endif

#include <tqlayout.h>

#ifdef PURE_QT
#include <tqfontdatabase.h>
#endif

namespace PropertyLib{

PFontCombo::PFontCombo(MultiProperty *property, TQWidget *parent, const char *name)
    :PropertyWidget(property, parent, name)
{
    TQHBoxLayout *l = new TQHBoxLayout(this, 0, 0);
    m_edit = new KFontCombo(this);
    m_edit->tqsetSizePolicy(TQSizePolicy::MinimumExpanding, TQSizePolicy::MinimumExpanding);
    l->addWidget(m_edit);
    
    /*adymo: KFontCombo seems to have a bug: when it is not editable, the signals
    activated(int) and textChanged(const TQString &) are not emitted*/
#ifdef PURE_QT
    TQFontDatabase fonts;
    m_edit->insertStringList(fonts.families());
    connect(m_edit, TQT_SIGNAL(activated(const TQString &)), this, TQT_SLOT(updateProperty(const TQString&)));
#else
    connect(m_edit, TQT_SIGNAL(textChanged(const TQString&)), this, TQT_SLOT(updateProperty(const TQString&)));
#endif
}

TQVariant PFontCombo::value() const
{
#ifndef PURE_QT
    return TQVariant(m_edit->currentFont());
#else
    return TQVariant(m_edit->currentText());
#endif
}

void PFontCombo::setValue(const TQVariant &value, bool emitChange)
{
    disconnect(m_edit, TQT_SIGNAL(textChanged(const TQString&)), this, TQT_SLOT(updateProperty(const TQString&)));
#ifndef PURE_QT
    m_edit->setCurrentFont(value.toString());
#else
    m_edit->setCurrentText(value.toString());
#endif
    connect(m_edit, TQT_SIGNAL(textChanged(const TQString&)), this, TQT_SLOT(updateProperty(const TQString&)));
    if (emitChange)
        emit propertyChanged(m_property, value);
}

void PFontCombo::updateProperty(const TQString &val)
{
    emit propertyChanged(m_property, TQVariant(val));
}

}

#ifndef PURE_QT
#include "pfontcombo.moc"
#endif
