/***************************************************************************
 *   Copyright (C) 2004 by Alexander Dymo                                  *
 *   cloudtemple@mskat.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#include "pcolorbutton.h"

#include <tqlayout.h>
#include <tqpainter.h>

#ifndef PURE_QT
#include <kcolorbutton.h>
#else
#include <tqpushbutton.h>
#include <tqpixmap.h>
#include <tqiconset.h>
#endif
#include <tqcolordialog.h>

namespace PropertyLib {

PColorButton::PColorButton(MultiProperty* property, TQWidget* parent, const char* name)
    :PropertyWidget(property, parent, name)
{
    TQHBoxLayout *l = new TQHBoxLayout(this, 0, 0);
#ifndef PURE_QT
    m_edit = new KColorButton(this);
    connect(m_edit, TQT_SIGNAL(changed(const TQColor&)), this, TQT_SLOT(updateProperty(const TQColor&)));
#else
    m_edit = new TQPushButton(this);
    connect(m_edit, TQT_SIGNAL(clicked()), this, TQT_SLOT(changeColor()));
#endif

    m_edit->tqsetSizePolicy(TQSizePolicy::MinimumExpanding, TQSizePolicy::MinimumExpanding);
    l->addWidget(m_edit);
}

TQVariant PColorButton::value() const
{
#ifndef PURE_QT
    return TQVariant(m_edit->color());
#else
    return TQVariant(m_color);
#endif
}

void PColorButton::drawViewer(TQPainter* p, const TQColorGroup& cg, const TQRect& r, const TQVariant& value)
{
/*    p->setBrush(value.toColor());
    p->setPen(TQt::NoPen);
    p->drawRect(r);*/
    p->setPen(TQt::NoPen);
    p->setBrush(cg.background());
    p->drawRect(r);

    p->setBrush(value.toColor());
    p->setPen(TQt::SolidLine);
    TQRect r2(r);
    r2.setTopLeft(r.topLeft() + TQPoint(5,5));
    r2.setBottomRight(r.bottomRight() - TQPoint(5,5));
    p->drawRect(r2);
}

void PColorButton::setValue(const TQVariant& value, bool emitChange)
{
#ifndef PURE_QT
    disconnect(m_edit, TQT_SIGNAL(changed(const TQColor&)), this, TQT_SLOT(updateProperty(const TQColor&)));
    m_edit->setColor(value.toColor());
    connect(m_edit, TQT_SIGNAL(changed(const TQColor&)), this, TQT_SLOT(updateProperty(const TQColor&)));
#else
    m_color = value.toColor();
    m_edit->setText(m_color.name());
    TQPixmap px;
    px.resize(14,14);
    px.fill(m_color);
    m_edit->setIconSet(px);
#endif
    if (emitChange)
        emit propertyChanged(m_property, value);

}

void PColorButton::updateProperty(const TQColor &// color
                                  )
{
    emit propertyChanged(m_property, value());
}

void PColorButton::changeColor()
{
#ifdef PURE_QT
   m_color = TQColorDialog::getColor(m_color,this);
   updateProperty(m_color);
   m_edit->setText(m_color.name());
   TQPixmap px;
   px.resize(14,14);
   px.fill(m_color);
   m_edit->setIconSet(px);

#endif
}

}
#ifndef PURE_QT
#include "pcolorbutton.moc"
#endif
