/***************************************************************************
 *   Copyright (C) 2003-2004 by Alexander Dymo                             *
 *   cloudtemple@mskat.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#include "pcheckbox.h"

#include <tqlayout.h>
#include <tqcheckbox.h>
#include <tqpainter.h>

#ifndef PURE_QT
#include <klocale.h>
#else
#include "compat_tools.h"
#endif

namespace PropertyLib{

PCheckBox::PCheckBox(MultiProperty *property, TQWidget *parent, const char *name)
    :PropertyWidget(property, parent, name)
{
    TQHBoxLayout *l = new TQHBoxLayout(this, 0, 0);
    m_edit = new TQCheckBox(this);
    m_edit->tqsetSizePolicy(TQSizePolicy::MinimumExpanding, TQSizePolicy::MinimumExpanding);
    l->addWidget(m_edit);
    
    connect(m_edit, TQT_SIGNAL(toggled(bool)), this, TQT_SLOT(updateProperty(bool)));
}

TQVariant PCheckBox::value() const
{
    return TQVariant(m_edit->isChecked());
}

void PCheckBox::setValue(const TQVariant &value, bool emitChange)
{
    disconnect(m_edit, TQT_SIGNAL(toggled(bool)), this, TQT_SLOT(updateProperty(bool)));
    m_edit->setChecked(value.toBool());
    connect(m_edit, TQT_SIGNAL(toggled(bool)), this, TQT_SLOT(updateProperty(bool)));
    if (emitChange)
        emit propertyChanged(m_property, value);
}

void PCheckBox::updateProperty(bool val)
{
    emit propertyChanged(m_property, TQVariant(val));
}

void PCheckBox::drawViewer(TQPainter *p, const TQColorGroup &cg, const TQRect &r, const TQVariant &value)
{
    p->setBrush(cg.background());
    p->setPen(TQt::NoPen);
    p->drawRect(r);
    p->drawText(r, TQt::AlignLeft | TQt::AlignVCenter | TQt::SingleLine, value.toBool() ? i18n("true") : i18n("false"));
}

}

#ifndef PURE_QT
#include "pcheckbox.moc"
#endif
