/* This file is part of the KDE project
   Copyright (C) 2003 Alexander Dymo <cloudtemple@mksat.net>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/
#include "klistviewaction.h"
#include "kcomboview.h"
#include "resizablecombo.h"

#include <tqtooltip.h>
#include <tqwhatsthis.h>

#include <kconfig.h>
#include <kglobal.h>

KListViewAction::~KListViewAction()
{
    KConfig *config = KGlobal::config();
    if (config && m_view->name())
    {
        config->setGroup("KListViewAction");
        config->writeEntry(m_view->name(), m_view->width());
    }
    delete m_view;
}

KListViewAction::KListViewAction(KComboView *view, const TQString & text, const KShortcut & cut,
    const TQObject * receiver, const char * slot, KActionCollection * parent, const char * name ):
    KWidgetAction(view, text, cut, receiver, slot, parent, name), m_view(view)
{
    m_view->setDuplicatesEnabled(false);
    m_view->setInsertionPolicy(KComboView::NoInsertion);

    loadComboWidth();
}

KListViewAction::KListViewAction( KComboView * view, const TQString & text, const KShortcut & cut,
    const TQObject * receiver, const char * slot, KActionCollection * parent, const char * name, const bool /*dummy*/ ):
    KWidgetAction(new ResizableCombo(view), text, cut, receiver, slot, parent, name), m_view(view)
{
    m_view->setDuplicatesEnabled(false);
    m_view->setInsertionPolicy(KComboView::NoInsertion);

    loadComboWidth();
}

KComboView * KListViewAction::view( ) const
{
    return m_view;
}

void KListViewAction::setToolTip( const TQString & str )
{
    TQToolTip::remove(m_view);
    TQToolTip::add(m_view, str);
}

void KListViewAction::setWhatsThis( const TQString & str )
{
    TQWhatsThis::remove(m_view);
    TQWhatsThis::add(m_view, str);
}

void KListViewAction::loadComboWidth( )
{
    KConfig *config = KGlobal::config();
    if (config && m_view->name())
    {
        config->setGroup("KListViewAction");
        m_view->setMinimumWidth(config->readNumEntry(m_view->name(), m_view->defaultWidth()));
    }
}

