/***************************************************************************
 *   Copyright (C) 2005 by Jens Dagerbo                                    *
 *   jens.dagerbo@swipnet.se                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kconfig.h>
#include <kglobal.h>
#include <kstandarddirs.h>

#include "settings.h"

TQString Settings::terminalEmulatorName( KConfig & config )
{
	config.setGroup("TerminalEmulator");
	bool useKDESetting = config.readBoolEntry( "UseKDESetting", true );
	TQString terminal;

	if ( useKDESetting )
	{
		KConfigGroup confGroup( KGlobal::config(), TQString::tqfromLatin1("General") );
		terminal = confGroup.readEntry("TerminalApplication", TQString::tqfromLatin1("konsole"));
	}
	else
	{
		terminal = config.readEntry( "TerminalApplication", TQString::tqfromLatin1("konsole"));
	}
	return terminal;
}

TQString Settings::profileByAttributes(const TQString &language, const TQStringList &keywords)
{
    KConfig config(locate("data", "kdevelop/profiles/projectprofiles"));
    config.setGroup(language);

    TQStringList profileKeywords = TQStringList::split("/", "Empty");
    if (config.hasKey("Keywords"))
        profileKeywords = config.readListEntry("Keywords");

    int idx = 0;
    for (TQStringList::const_iterator it = profileKeywords.constBegin();
        it != profileKeywords.constEnd(); ++it)
    {
        if (keywords.contains(*it))
        {
            idx = profileKeywords.findIndex(*it);
            break;
        }
    }

    TQStringList profiles;
    if (config.hasKey("Profiles"))
    {
        profiles = config.readListEntry("Profiles");
        return profiles[idx];
    }
    return "KDevelop";
}
