/***************************************************************************
*   Copyright (C) 2006 by Andras Mantia                                   *
*   amantia@kde.org                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

#include "blockingkprocess.h"

#include <tqapplication.h>
#include <tqtimer.h>

BlockingKProcess::BlockingKProcess(TQObject *parent, const char *name)
  : KProcess(parent, name)
{
  m_stdOut = "";
  m_stdErr = "";
  m_timeoutValue = 60;
  m_timer = 0L;
  
  connect(this, TQT_SIGNAL(receivedStdout(KProcess *, char *, int)),
          this, TQT_SLOT(slotReceivedStdOut(KProcess *, char *, int)));
  connect(this, TQT_SIGNAL(receivedStderr(KProcess *, char *, int)),
          this, TQT_SLOT(slotReceivedStdErr(KProcess *, char *, int)));
  connect(this, TQT_SIGNAL(processExited(KProcess *)),
          this, TQT_SLOT(slotProcessExited(KProcess *)));  
}

BlockingKProcess::BlockingKProcess()
 : KProcess()
{
  m_stdOut = "";
  m_stdErr = "";
  m_timeoutValue = 60;
  m_timer = 0L;
  connect(this, TQT_SIGNAL(receivedStdout(KProcess *, char *, int)),
          this, TQT_SLOT(slotReceivedStdOut(KProcess *, char *, int)));
  connect(this, TQT_SIGNAL(receivedStderr(KProcess *, char *, int)),
          this, TQT_SLOT(slotReceivedStdErr(KProcess *, char *, int)));
  connect(this, TQT_SIGNAL(processExited(KProcess *)),
          this, TQT_SLOT(slotProcessExited(KProcess *)));  
}


BlockingKProcess::~BlockingKProcess()
{
}
bool BlockingKProcess::start(RunMode runmode, Communication comm)
{
  if (KProcess::start(runmode, comm))
  {
    m_timeout = false;
    m_timer = new TQTimer();
    connect(m_timer, TQT_SIGNAL(timeout()), this, TQT_SLOT(slotTimeOut()));
    m_timer->start(m_timeoutValue*1000, true);
    enter_loop();
    delete m_timer;
    m_timer = 0L;
    return !m_timeout;
  } else
    return false;
}


void BlockingKProcess::slotReceivedStdOut(KProcess *, char *buffer, int buflen)
{
  m_stdOut += TQString::tqfromLatin1(buffer, buflen);
}

void BlockingKProcess::slotReceivedStdErr(KProcess *, char *buffer, int buflen)
{
  m_stdErr += TQString::tqfromLatin1(buffer, buflen);
}

void BlockingKProcess::slotProcessExited(KProcess *)
{
  tqApp->exit_loop();
}

void BlockingKProcess::slotTimeOut()
{
  m_timeout = true;
  kill();
  tqApp->exit_loop();
}


void qt_enter_modal( TQWidget *widget );
void qt_leave_modal( TQWidget *widget );

void BlockingKProcess::enter_loop()
{
  TQWidget dummy(0,0,WType_Dialog | WShowModal);
  dummy.setFocusPolicy( TQ_NoFocus );
  qt_enter_modal(&dummy);
  tqApp->enter_loop();
  qt_leave_modal(&dummy);
}


#include "blockingkprocess.moc"
