/***************************************************************************
    begin                : Tue May 13 2003
    copyright            : (C) 2003 by John Birch
    email                : jbb@kdevelop.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _GDBBreakpointWidget_H_
#define _GDBBreakpointWidget_H_

#include <tqhbox.h>
#include <tqpopupmenu.h>
#include <tqtable.h>
#include <tqguardedptr.h>
#include <tqvaluevector.h>

#include "mi/gdbmi.h"
#include "gdbcontroller.h"

class TQDomElement;
class TQToolButton;
class TQLabel;
class KURL;

/***************************************************************************/
/***************************************************************************/
/***************************************************************************/

namespace GDBDebugger
{
class Breakpoint;
class BreakpointTableRow;
class GDBTable;
class GDBController;

class GDBBreakpointWidget : public TQHBox
{
    Q_OBJECT
  TQ_OBJECT

public:
    GDBBreakpointWidget( GDBController* controller,
                         TQWidget* parent=0, const char* name=0 );
    virtual ~GDBBreakpointWidget();

    void reset();

    void savePartialProjectSession(TQDomElement* el);
    void restorePartialProjectSession(const TQDomElement* el);

    bool hasWatchpointForAddress(unsigned long long address) const;


public slots:
    // Connected to from the editor widget:
    void slotToggleBreakpoint(const TQString &filename, int lineNum);
    void slotToggleBreakpointEnabled(const TQString &fileName, int lineNum);

    // Connected to from the variable widget:
    void slotToggleWatchpoint(const TQString &varName);

    void slotBreakpointSet(Breakpoint*);

    void slotRefreshBP(const KURL &filename);

    void slotBreakpointHit(int id);

    
protected:
    virtual void focusInEvent(TQFocusEvent *e);


    friend class BreakpointActionCell; // for access to slotNewValue
private slots:
    void slotRemoveBreakpoint();
    void slotRemoveAllBreakpoints();
    void slotEditBreakpoint(const TQString &fileName, int lineNum);
    void slotEditBreakpoint();
    void slotAddBlankBreakpoint(int idx);
    void slotRowDoubleClicked(int row, int col, int button, const TQPoint & mousePos);
    void slotContextMenuShow( int row, int col, const TQPoint &mousePos );
    void slotContextMenuSelect( int item );
    void slotEditRow(int row, int col, const TQPoint & mousePos);
    void slotNewValue(int row, int col);
    void editTracing(TQTableItem* item);
    void slotBreakpointModified(Breakpoint*);

    void slotEvent(GDBController::event_t);
    void slotWatchpointHit(int id,
                           const TQString& oldValue,
                           const TQString& newValue);

signals:
    void publishBPState(const Breakpoint& brkpt);
    void refreshBPState(const Breakpoint& brkpt);
    void gotoSourcePosition(const TQString &fileName, int lineNum);
    // Emitted when output from yet another passed tracepoint is available.
    void tracingOutput(const char*);

private:
    BreakpointTableRow* find(Breakpoint *bp);
    BreakpointTableRow* findId(int id);
    BreakpointTableRow* findKey(int BPKey);

    void setActive();
    BreakpointTableRow* addBreakpoint(Breakpoint *bp);
    void removeBreakpoint(BreakpointTableRow* btr);

    void sendToGdb(Breakpoint &);

    void handleBreakpointList(const GDBMI::ResultRecord&);
    void handleTracingPrintf(const TQValueVector<TQString>& s);

private:
    GDBController*  controller_;

    GDBTable*       m_table;
    TQPopupMenu*     m_ctxMenu;
};

class BreakpointTableRow;

/** Custom table cell class for cells that require complex editing.
    When current, the cell shows a "..." on the right. When clicked,
    the 'edit' signal is emitted that can be be used to pop-up
    a dialog box. 

    When editing is done, the receiver of 'edit' should change the
    value in the table, and then call the 'updateValue' method.    
 */
class ComplexEditCell : public TQObject, public TQTableItem
{
    Q_OBJECT
  TQ_OBJECT
public:

    ComplexEditCell(TQTable* table);

    /** Called by TQt when the current cell should become editable.
        In our case, when the item becomes current. Creates a widget
        that will be shown in the cell and should be able to edit cell
        content. In our case -- text plus "..." button that invokes 
        action dialog.        
    */
    TQWidget* createEditor() const;    

    void updateValue();

private slots:

    /** Called when the "..." button is clicked. */
    void slotEdit();

signals:
    void edit(TQTableItem*);

private:
    mutable TQGuardedPtr<TQLabel> label_;
};


/***************************************************************************/
/***************************************************************************/
/***************************************************************************/

}

#endif
