/***************************************************************************
 *   Copyright (C) 1999-2001 by John Birch                                 *
 *   jbb@kdevelop.org                                                      *
 *   Copyright (C) 2001 by Bernd Gehrmann                                  *
 *   bernd@kdevelop.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "debuggerconfigwidget.h"

#include "debuggerpart.h"
#include "kdevproject.h"

#include "domutil.h"
#include <kurlrequester.h>
#include <klineedit.h>

#include <tqcheckbox.h>
#include <tqfileinfo.h>
#include <tqradiobutton.h>

namespace GDBDebugger
{

DebuggerConfigWidget::DebuggerConfigWidget(DebuggerPart* part, TQWidget *parent, const char *name)
    : DebuggerConfigWidgetBase(parent, name), dom(*part->projectDom())
{
    gdbPath_edit->setMode(KFile::File|KFile::ExistingOnly|KFile::LocalOnly);

    gdbPath_edit->setURL(      DomUtil::readEntry(dom, "/kdevdebugger/general/gdbpath"));

    TQString shell =             DomUtil::readEntry(dom, "/kdevdebugger/general/dbgshell","no_value");
    if( shell == TQString("no_value") )
    {
	shell = TQString();
    }
    debuggingShell_edit->setURL( shell );

    // Use setFile instead?
    configGdbScript_edit->setURL( DomUtil::readEntry(dom, "/kdevdebugger/general/configGdbScript"));
    runShellScript_edit ->setURL( DomUtil::readEntry(dom, "/kdevdebugger/general/runShellScript"));
    runGdbScript_edit   ->setURL( DomUtil::readEntry(dom, "/kdevdebugger/general/runGdbScript"));

    displayStaticMembers_box->setChecked(  DomUtil::readBoolEntry(dom, "/kdevdebugger/display/staticmembers", false));
    asmDemangle_box->setChecked(           DomUtil::readBoolEntry(dom, "/kdevdebugger/display/demanglenames", true));
    breakOnLoadingLibrary_box->setChecked( DomUtil::readBoolEntry(dom, "/kdevdebugger/general/breakonloadinglibs", true));
    dbgTerminal_box->setChecked(           DomUtil::readBoolEntry(dom, "/kdevdebugger/general/separatetty", false));
    enableFloatingToolBar_box->setChecked( DomUtil::readBoolEntry(dom, "/kdevdebugger/general/floatingtoolbar", false));
    int outputRadix = DomUtil::readIntEntry(dom, "/kdevdebugger/display/outputradix", 10);

    switch (outputRadix)
    {
    case 8:
      outputRadixOctal->setChecked(true);
      break;
    case 16:
      outputRadixHexadecimal->setChecked(true);
      break;
    case 10:
    default:
      outputRadixDecimal->setChecked(true);
      break;
    }


    if( DomUtil::readBoolEntry( dom, "/kdevdebugger/general/raiseGDBOnStart", false ) )
    {
        radioGDB->setChecked(true);
    }else
    {
        radioFramestack->setChecked(true);
    }

    // ??? DomUtil::readEntry(dom, "/kdevdebugger/general/allowforcedbpset");

    resize(tqsizeHint());
}


DebuggerConfigWidget::~DebuggerConfigWidget()
{}


void DebuggerConfigWidget::accept()
{
    DomUtil::writeEntry(dom, "/kdevdebugger/general/gdbpath", gdbPath_edit->url());
    DomUtil::writeEntry(dom, "/kdevdebugger/general/dbgshell", debuggingShell_edit->url());

    DomUtil::writeEntry(dom, "/kdevdebugger/general/configGdbScript", configGdbScript_edit->url());
    DomUtil::writeEntry(dom, "/kdevdebugger/general/runShellScript", runShellScript_edit ->url());
    DomUtil::writeEntry(dom, "/kdevdebugger/general/runGdbScript", runGdbScript_edit   ->url());

    DomUtil::writeBoolEntry(dom, "/kdevdebugger/display/staticmembers", displayStaticMembers_box->isChecked());
    DomUtil::writeBoolEntry(dom, "/kdevdebugger/display/demanglenames", asmDemangle_box->isChecked());
    DomUtil::writeBoolEntry(dom, "/kdevdebugger/general/breakonloadinglibs", breakOnLoadingLibrary_box->isChecked());
    DomUtil::writeBoolEntry(dom, "/kdevdebugger/general/separatetty", dbgTerminal_box->isChecked());
    DomUtil::writeBoolEntry(dom, "/kdevdebugger/general/floatingtoolbar", enableFloatingToolBar_box->isChecked());

    int outputRadix;
    if (outputRadixOctal->isChecked())
      outputRadix = 8;
    else if (outputRadixHexadecimal->isChecked())
      outputRadix = 16;
    else
      outputRadix = 10;

    DomUtil::writeIntEntry(dom, "/kdevdebugger/display/outputradix", outputRadix);

    if( radioGDB->isChecked() )
    {
        DomUtil::writeBoolEntry(dom, "/kdevdebugger/general/raiseGDBOnStart", true);
    }else
    {
        DomUtil::writeBoolEntry(dom, "/kdevdebugger/general/raiseGDBOnStart", false);
    }

}

}

#include "debuggerconfigwidget.moc"
