/*
 */
#include <stdlib.h>
#include <unistd.h>
#include <iostream>

#include <tqstring.h>
#include <tqstringlist.h>
#include <tqfile.h>
#include <tqregexp.h>

#include <kdebug.h>

#include "ada_utils.hpp"
#include "adasupport.hpp"

TQString qtext (const RefAdaAST& n)
{
  return TQString::tqfromLatin1 (text (n).c_str ());
}

TQStringList qnamelist (const RefAdaAST& n)
{
  TQString txt = qtext (n);
  // kdDebug() << "qnamelist: input is " << txt << endl;
  return TQStringList::split ('.', txt);
}

TQString ada_spec_filename (const TQString& comp_unit_name)
{
   TQString fn (comp_unit_name.lower ());

   fn.replace (TQRegExp("."), "-");
   fn += ".ads";
   return fn;
}

TQString fq_specfilename (const TQString& comp_unit_name)
{
    TQString fname = ada_spec_filename (comp_unit_name);

    if (TQFile::exists (fname))
        return fname;

    TQString adaincpath = getenv ("ADA_INCLUDE_PATH");
    if (adaincpath.isNull ())
        return TQString();

    TQStringList dirs = TQStringList::split (':', adaincpath);
    TQString fq_filename;
    for (TQStringList::Iterator it = dirs.begin (); it != dirs.end (); it++) {
        fq_filename = *it;
        if (! fq_filename.endsWith ("/"))
            fq_filename += "/";
        fq_filename += fname;
        if (TQFile::exists (fq_filename))
            return fq_filename;
    }
    if (fname.startsWith ("ada-") ||
        fname.startsWith ("text_io") ||
        fname.startsWith ("system") ||
        fname.startsWith ("unchecked_")) {
        kdDebug () << "resolution of Ada predefined library is TBD" << endl;
    } else {
        kdDebug () << "Cannot find file " << fname << endl;
    }
    return TQString();
}

