/**********************************************************************
** Copyright (C) 2000 Trolltech AS.  All rights reserved.
**
** This file is part of TQt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid TQt Enterprise Edition or TQt Professional Edition
** licenses may use this file in accordance with the TQt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about TQt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef STYLEDBUTTON_H
#define STYLEDBUTTON_H

#include <tqbutton.h>
#include <tqpixmap.h>

class TQColor;
class TQBrush;
class FormWindow;

class StyledButton : public TQButton
{
    Q_OBJECT
  TQ_OBJECT

    TQ_PROPERTY( TQColor color READ color WRITE setColor )
    TQ_PROPERTY( TQPixmap pixmap READ pixmap WRITE setPixmap )
    TQ_PROPERTY( EditorType editor READ editor WRITE setEditor )
    TQ_PROPERTY( bool scale READ scale WRITE setScale )

    Q_ENUMS( EditorType )

public:
    enum EditorType { ColorEditor, PixmapEditor };

    StyledButton( TQWidget* parent = 0, const char* name = 0 );
    StyledButton( const TQBrush& b, TQWidget* parent = 0, const char* name = 0, WFlags f = 0 );
    ~StyledButton();

    void setEditor( EditorType );
    EditorType editor() const;

    void setColor( const TQColor& );
    void setPixmap( const TQPixmap& );

    TQPixmap* pixmap() const;
    TQColor color() const;

    void setScale( bool );
    bool scale() const;

    TQSize tqsizeHint() const;
    TQSize tqminimumSizeHint() const;

    void setFormWindow( FormWindow *fw ) { formWindow = fw; }

public slots:
    virtual void onEditor();

signals:
    void changed();

protected:
    void mousePressEvent(TQMouseEvent*);
    void mouseMoveEvent(TQMouseEvent*);
#ifndef TQT_NO_DRAGANDDROP
    void dragEnterEvent ( TQDragEnterEvent * );
    void dragMoveEvent ( TQDragMoveEvent * );
    void dragLeaveEvent ( TQDragLeaveEvent * );
    void dropEvent ( TQDropEvent * );
#endif // TQT_NO_DRAGANDDROP
    void drawButton( TQPainter* );
    void drawButtonLabel( TQPainter* );
    void resizeEvent( TQResizeEvent* );
    void scalePixmap();

private:
    TQPixmap* pix;
    TQPixmap* spix;  // the pixmap scaled down to fit into the button
    TQColor col;
    EditorType edit;
    bool s;
    FormWindow *formWindow;
    TQPoint pressPos;
    bool mousePressed;
};

#endif //STYLEDBUTTON_H
