/**********************************************************************
** Copyright (C) 2001-2002 Trolltech AS.  All rights reserved.
**
** This file is part of TQt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid TQt Enterprise Edition or TQt Professional Edition
** licenses may use this file in accordance with the TQt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about TQt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#include "outputwindow.h"
#include "designerappiface.h"
#include "metadatabase.h"
#include "mainwindow.h"

#include <tqlistview.h>
#include <tqtextedit.h>
#include <tqapplication.h>
#include <tqheader.h>
#include <stdlib.h>
#include <stdio.h>
#include <tqpainter.h>

#include <klocale.h>

static TQTextEdit *debugoutput = 0;
bool debugToStderr = FALSE;

TQtMsgHandler OutputWindow::oldMsgHandler = 0;

OutputWindow::OutputWindow( TQWidget *parent )
    : TQTabWidget( parent, "output_window" ), debugView( 0 ), errorView( 0 )
{
    setupDebug();
    setupError();
    iface = new DesignerOutputDockImpl( this );
}

OutputWindow::~OutputWindow()
{
    debugoutput = debugView = 0;
    errorView = 0;
    if ( !debugToStderr )
	tqInstallMsgHandler( oldMsgHandler );
    delete iface;
}

void OutputWindow::shuttingDown()
{
    if ( !debugToStderr )
	tqInstallMsgHandler( oldMsgHandler );
}

void OutputWindow::setupError()
{
    errorView = new TQListView( this, "OutputWindow::errorView" );
    errorView->setSorting( -1 );
    connect( errorView, TQT_SIGNAL( currentChanged( TQListViewItem* ) ),
	     this, TQT_SLOT( currentErrorChanged( TQListViewItem* ) ) );
    connect( errorView, TQT_SIGNAL( clicked( TQListViewItem* ) ),
	     this, TQT_SLOT( currentErrorChanged( TQListViewItem* ) ) );

    if ( MetaDataBase::languages().count() > 1 )
	addTab( errorView, i18n( "Warnings/Errors" ) );
    else
	errorView->hide();
    errorView->addColumn( i18n( "Type" ) );
    errorView->addColumn( i18n( "Message" ) );
    errorView->addColumn( i18n( "Line" ) );
    errorView->addColumn( i18n( "Location" ) );
    errorView->setResizeMode( TQListView::LastColumn );
    errorView->setColumnWidth( 0, errorView->fontMetrics().width( "WARNING1234" ) );
    errorView->setColumnWidth( 1, errorView->fontMetrics().width( "ABCDEFGHIJKLMNOPTQRSTUVWXYZABCDEFGHIJKLMNOPTQRSTUVWXYZABCDEFGHIJKLMNOP" ) );
    errorView->setColumnWidth( 2, errorView->fontMetrics().width( "9999999" ) );
    errorView->setColumnAlignment( 2, TQt::AlignRight );
    errorView->setAllColumnsShowFocus( TRUE );
}

static void debugMessageOutput( TQtMsgType type, const char *msg )
{
    TQString s( msg );
    s += "\n";

    if ( type != QtFatalMsg ) {
	if ( debugoutput && debugoutput->isVisible() )
	    debugoutput->append( s );
	else if ( OutputWindow::oldMsgHandler && OutputWindow::oldMsgHandler != debugMessageOutput )
	    (*OutputWindow::oldMsgHandler)( type, msg );
	else
	    fputs( s.latin1(), stderr );
    } else {
	fputs( s.latin1(), stderr );
	abort();
    }

    tqApp->flush();
}

void OutputWindow::setupDebug()
{
    debugoutput = debugView = new TQTextEdit( this, "OutputWindow::debugView" );
    //debugView->setReadOnly( TRUE );
    addTab( debugView, "Debug Output" );

    if ( !debugToStderr )
	oldMsgHandler = tqInstallMsgHandler( debugMessageOutput );
}

void OutputWindow::setErrorMessages( const TQStringList &errors, const TQValueList<uint> &lines,
				     bool clear, const TQStringList &locations,
				     const TQObjectList &locationObjects )
{
    if ( clear )
	errorView->clear();
    TQStringList::ConstIterator mit = errors.begin();
    TQValueList<uint>::ConstIterator lit = lines.begin();
    TQStringList::ConstIterator it = locations.begin();
    TQObjectList objects = (TQObjectList)locationObjects;
    TQObject *o = objects.first();
    TQListViewItem *after = 0;
    for ( ; lit != lines.end() && mit != errors.end(); ++lit, ++mit, ++it, o = objects.next() )
	after = new ErrorItem( errorView, after, *mit, *lit, *it, o );
    setCurrentPage( 1 );
}

DesignerOutputDock *OutputWindow::iFace()
{
    return iface;
}

void OutputWindow::appendDebug( const TQString &text )
{
    debugView->append( text + "\n" );
}

void OutputWindow::clearErrorMessages()
{
    errorView->clear();
}

void OutputWindow::clearDebug()
{
    debugView->clear();
}

void OutputWindow::showDebugTab()
{
    showPage( debugView );
}

void OutputWindow::currentErrorChanged( TQListViewItem *i )
{
    if ( !i )
	return;
    ErrorItem *ei = (ErrorItem*)i;
    ei->setRead( TRUE );
    MainWindow::self->showSourceLine( ei->location(), ei->line() - 1, MainWindow::Error );
}



ErrorItem::ErrorItem( TQListView *parent, TQListViewItem *after, const TQString &message, int line,
		      const TQString &locationString, TQObject *locationObject )
    : TQListViewItem( parent, after )
{
    setMultiLinesEnabled( TRUE );
    TQString m( message );
    type = m.startsWith( "Warning: " ) ? Warning : Error;
    m = m.mid( m.find( ':' ) + 1 );
    setText( 0, type == Error ? "Error" : "Warning" );
    setText( 1, m );
    setText( 2, TQString::number( line ) );
    setText( 3, locationString );
    object = locationObject;
    read = !after;
    if ( !after ) {
	parent->setSelected( this, TRUE );
	parent->setCurrentItem( this );
    }
}

void ErrorItem::paintCell( TQPainter *p, const TQColorGroup & cg,
			   int column, int width, int tqalignment )
{
    TQColorGroup g( cg );
    g.setColor( TQColorGroup::Text, type == Error ? TQt::red : TQt::darkYellow );
    if ( !read ) {
	TQFont f( p->font() );
	f.setBold( TRUE );
	p->setFont( f );
    }
    TQListViewItem::paintCell( p, g, column, width, tqalignment );
}
