/**********************************************************************
** Copyright (C) 2002 Trolltech AS.  All rights reserved.
**
** This file is part of TQt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid TQt Enterprise Edition or TQt Professional Edition
** licenses may use this file in accordance with the TQt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about TQt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef LISTBOXDND_H
#define LISTBOXDND_H

#include <tqptrlist.h>
#include <tqlistbox.h>
#include "listdnd.h"

typedef TQPtrList<TQListBoxItem> ListBoxItemList;

class ListBoxDnd : public ListDnd
{
    Q_OBJECT
  TQ_OBJECT
public:
    // dragModes are enumerated in ListDnd
    ListBoxDnd( TQListBox * eventSource, const char * name = 0 );
    
signals:
    void dropped( TQListBoxItem * );
    void dragged( TQListBoxItem * );

public slots:
    void confirmDrop( TQListBoxItem * );

protected:
    virtual bool dropEvent( TQDropEvent * event );
    virtual bool mouseMoveEvent( TQMouseEvent * event );
    virtual void updateLine( const TQPoint & pos );
    virtual bool canDecode( TQDragEnterEvent * event );

private:
    TQListBoxItem * itemAt( TQPoint pos );
    int buildList( ListBoxItemList & list );
    void insertList( ListBoxItemList & list );
    void removeList( ListBoxItemList & list );
};

#endif //LISTBOXDND_H
