/***************************************************************************
 *   Copyright (C) 2001-2002 by Bernd Gehrmann                             *
 *   bernd@kdevelop.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "scriptnewfiledlg.h"

#include <tqcheckbox.h>
#include <tqfile.h>
#include <tqfileinfo.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <klineedit.h>
#include <tqpushbutton.h>
#include <kbuttonbox.h>
#include <kdebug.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kstdguiitem.h>
#include <kdeversion.h>

#include "scriptprojectpart.h"
#include "filetemplate.h"


ScriptNewFileDialog::ScriptNewFileDialog(ScriptProjectPart *part,
                                         TQWidget *parent, const char *name)
    : TQDialog(parent, name, true)
{
    setCaption(i18n("New File"));

    TQLabel *filename_label = new TQLabel(i18n("&File name:"), this);

    filename_edit = new KLineEdit(this);
    filename_edit->setFocus();
    filename_label->setBuddy(this);
    TQFontMetrics fm(filename_edit->fontMetrics());
    filename_edit->setMinimumWidth(fm.width('X')*35);

    usetemplate_box = new TQCheckBox(i18n("&Use file template"), this);
    usetemplate_box->setChecked(true);

    TQFrame *frame = new TQFrame(this);
    frame->setFrameStyle(TQFrame::HLine | TQFrame::Sunken);

    KButtonBox *buttonbox = new KButtonBox(this);
    buttonbox->addStretch();
    TQPushButton *ok_button = buttonbox->addButton(KStdGuiItem::ok());
    TQPushButton *cancel_button = buttonbox->addButton(KStdGuiItem::cancel());
    ok_button->setDefault(true);
    connect( ok_button, TQT_SIGNAL(clicked()), this, TQT_SLOT(accept()) );
    connect( cancel_button, TQT_SIGNAL(clicked()), this, TQT_SLOT(reject()) );
    buttonbox->tqlayout();

    TQVBoxLayout *tqlayout = new TQVBoxLayout(this, 10, 4);
    tqlayout->addWidget(filename_label);
    tqlayout->addWidget(filename_edit);
    tqlayout->addWidget(usetemplate_box);
    tqlayout->addWidget(frame, 0);
    tqlayout->addWidget(buttonbox, 0);

    m_part = part;
}


ScriptNewFileDialog::~ScriptNewFileDialog()
{}


void ScriptNewFileDialog::accept()
{
    TQString fileName = filename_edit->text();
    if (fileName.find('/') != -1) {
        KMessageBox::sorry(this, i18n("Please enter the file name without '/' and so on."));
        return;
    }

    KDevProject *project = m_part->project();
    if (!project->activeDirectory().isEmpty())
        fileName.prepend(project->activeDirectory() + "/");
    TQString destpath = project->projectDirectory() + "/" + fileName;

    if (TQFileInfo(destpath).exists()) {
        KMessageBox::sorry(this, i18n("A file with this name already exists."));
        return;
    }

    bool success = false;

    if (usetemplate_box->isChecked()) {
        TQString extension = TQFileInfo(destpath).extension();
        if (!FileTemplate::exists(m_part, extension)) {
            KMessageBox::sorry(this, i18n("A file template for this extension does not exist."));
            return;
        }
        success = FileTemplate::copy(m_part, extension, destpath);
    } else {
        TQFile f(destpath);
        success = f.open(IO_WriteOnly);
        if (success)
            f.close();
    }

    if (!success)
        KMessageBox::sorry(this, i18n("Could not create the new file."));

    kdDebug(9015) << "AddFile1: " << fileName << endl;
    m_part->addFile(fileName);

    TQDialog::accept();
}

#include "scriptnewfiledlg.moc"
