/***************************************************************************
*   Copyright (C) 2001 by Bernd Gehrmann                                  *
*   bernd@kdevelop.org                                                    *
*   Copyright (C) 2002 by Jakob Simon-Gaarde                              *
*   jakob@jsg.dk                                                          *
*   Copyright (C) 2002-2003 by Alexander Dymo                             *
*   cloudtemple@mksat.net                                                 *
*   Copyright (C) 2003 by Thomas Hasart                                   *
*   thasart@gmx.de                                                        *
*   Copyright (C) 2006 by Andreas Pakulat                                 *
*   apaku@gmx.de                                                          *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

#ifndef _TROLLPROJECTWIDGET_H_
#define _TROLLPROJECTWIDGET_H_

#include <tqdict.h>
#include <tqlistview.h>
#include <tqmap.h>
#include <tqstrlist.h>
#include <tqvbox.h>
#include <tqtoolbutton.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kdeversion.h>
#include <tqbutton.h>
#include <tqfileinfo.h>
#include <tqptrlist.h>
#include "choosesubprojectdlg.h"
#include "newwidgetdlg.h"
#include "domutil.h"
#include "qmakescopeitem.h"

class TrollProjectPart;
class KListView;
class ProjectConfigurationDlg;

class TrollProjectWidget : public TQVBox
{
    Q_OBJECT
  TQ_OBJECT

public:
    TrollProjectWidget( TrollProjectPart *part );
    ~TrollProjectWidget();

    void openProject( const TQString &dirName );
    void closeProject();

    /**
     * A list of the (relative) names of all subprojects (== subdirectories).
     */
    //TQStringList allSubprojects();
    /**
     * A list of the (relative) names of all libraries.
     */
    TQStringList allLibraries();
    /**
     * A list of all files that belong to the project.
     **/
    TQStringList allFiles();
    /**
     * The top level directory of the project.
     **/
    TQString projectDirectory();
    /**
     * The directory of the currently active subproject.
     */
    TQString subprojectDirectory();
    /**
     * The directory of the currently active subproject.
     */
    TQString getCurrentTarget();

    TQString getCurrentDestDir();

    TQString getCurrentOutputFilename();

    void addFileToCurrentSubProject( GroupItem *titem, const TQString &filename );
    void addFileToCurrentSubProject( GroupItem::GroupType gtype, const TQString &filename );
    void addFiles( TQStringList &files, bool relativeToProjectRoot = true );
    void emitAddedFile( const TQString &name );
    void emitRemovedFile( const TQString &name );

    TQString getUiFileLink( const TQString &path, const TQString& filename );
    bool isTMakeProject();

    enum TrollProjectView { SubprojectView, DetailsView };
    void setLastFocusedView( TrollProjectView view );
    enum SaveType { AlwaysSave, NeverSave, Ask };
    QMakeScopeItem* currentSubproject();

    bool showFilenamesOnly() const;
    bool showVariablesInTree() const;

public slots:
    void slotBuildTarget();
    void slotInstallTarget();
    void slotRebuildTarget();
    void slotCleanTarget();
    void slotDistCleanTarget();
    void slotExecuteTarget();

    void slotBuildProject();
    void slotInstallProject();
    void slotRebuildProject();
    void slotCleanProject();
    void slotDistCleanProject();
    void slotExecuteProject();

    void slotBuildOpenFile();
    void slotBuildSelectedFile();

    void slotConfigureProject();
    void slotAddFiles();
    void slotNewFile();
    void slotRemoveFile();

protected:
    virtual void focusInEvent( TQFocusEvent *e );

private slots:
    void slotOverviewSelectionChanged( TQListViewItem *item );
    void slotOverviewContextMenu( KListView *, TQListViewItem *item, const TQPoint &p );
    void slotDetailsSelectionChanged( TQListViewItem* );
    void slotDetailsExecuted( TQListViewItem *item );
    void slotDetailsContextMenu( KListView *, TQListViewItem *item, const TQPoint &p );
    void slotExcludeFileFromScopeButton();
    void slotAddSubproject( QMakeScopeItem *spitem = 0 );
    void slotRemoveSubproject( QMakeScopeItem *spitem = 0 );
    void slotCreateScope( QMakeScopeItem *spitem = 0 );
    void slotRemoveScope( QMakeScopeItem *spitem = 0 );
    void slotDisableSubproject( QMakeScopeItem* spitem = 0 );
    void slotProjectDirty( const TQString& );

    void createQMakeScopeItems();

private:
    void cleanDetailView( QMakeScopeItem *item );
    void runClean( QMakeScopeItem*, const TQString& );
    void buildProjectDetailTree( QMakeScopeItem *item, KListView *listviewControl );
    void removeFile( QMakeScopeItem *spitem, FileItem *fitem );
    void addSubprojectToItem( QMakeScopeItem*, const TQString& );
    void setupContext();
    //     void parseScope(QMakeScopeItem *item,TQString scopeString, Scope *scope);
    GroupItem* getInstallRoot( QMakeScopeItem *item );
    GroupItem* getInstallObject( QMakeScopeItem *item, const TQString& objectname );
    TQString constructMakeCommandLine( Scope* s = 0 );

    void createMakefileIfMissing( const TQString &dir, QMakeScopeItem *item );

    void runTQMakeRecursive( QMakeScopeItem* proj);
    void buildFile( QMakeScopeItem* spitem, FileItem* fitem);

    /*fileName: full base file name like TQFileInfo::baseName ( true )*/
    TQPtrList<QMakeScopeItem> findSubprojectForFile( TQFileInfo fi );
    void findSubprojectForFile( TQPtrList<QMakeScopeItem> &list, QMakeScopeItem * item, TQString absFilePath );
    QMakeScopeItem* findSubprojectForPath( const TQString& );
    //    TQString makeEnvironment();

    TrollProjectWidget::SaveType dialogSaveBehaviour() const;

    QMakeScopeItem *findSubprojectForScope( QMakeScopeItem *scope );

    void reloadProjectFromFile( QMakeScopeItem* item );
    TQMap<TQString,TQString> qmakeEnvironment() const;

    TQVBox *overviewContainer;
    KListView *overview;
    TQHBox *projectTools;
    TQToolButton *addSubdirButton;
    TQToolButton *createScopeButton;

    TQToolButton *buildProjectButton;
    TQToolButton *rebuildProjectButton;
    TQToolButton *executeProjectButton;

    TQToolButton *buildTargetButton;
    TQToolButton *rebuildTargetButton;
    TQToolButton *executeTargetButton;

    TQToolButton *buildFileButton;
    TQToolButton *projectconfButton;

    TQVBox *detailContainer;
    KListView *details;
    TQHBox *fileTools;
    TQToolButton *addfilesButton;
    TQToolButton *newfileButton;
    TQToolButton *removefileButton;
    TQToolButton *excludeFileFromScopeButton;

    DomUtil::PairList m_subclasslist;
    QMakeScopeItem *m_shownSubproject;
    QMakeScopeItem *m_rootSubproject;
    Scope* m_rootScope;
    TrollProjectPart *m_part;
    ProjectConfigurationDlg* m_configDlg;

    TrollProjectView m_lastFocusedView;

    bool m_filesCached;
    bool m_showFilenamesOnly;
    bool m_showVariablesInTree;
    TQStringList m_allFilesCache;

    friend class ChooseSubprojectDlg;
    friend class ProjectConfigurationDlg;
};

#endif

// kate: space-indent on; indent-width 4; tab-width 4; replace-tabs on
