/* This file is part of the KDE project
   Copyright (C) 2001-2002 Bernd Gehrmann <bernd@kdevelop.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef _MAKEOPTIONSWIDGET_H_
#define _MAKEOPTIONSWIDGET_H_

#include "makeoptionswidgetbase.h"

#include <tqdom.h>

class EnvironmentVariablesWidget;

/**
Make options widget.
*/
class MakeOptionsWidget : public MakeOptionsWidgetBase
{
    Q_OBJECT
  TQ_OBJECT
    
public:
    MakeOptionsWidget( TQDomDocument &dom, const TQString &configGroup,
                       TQWidget *parent=0, const char *name=0 );
    ~MakeOptionsWidget();

public slots:
    void accept();

private:
    TQDomDocument &m_dom;
    TQString m_configGroup;
    EnvironmentVariablesWidget* m_environmentVariablesWidget;
};

#endif
