/**********************************************************************

	--- TQt Architect generated file ---

	File: servercontroller.h
	Last generated: Sat Nov 29 08:50:19 1997

 Now Under CVS control.

 $$Id: servercontroller.h 1246260 2011-08-10 22:19:39Z tpearson $$

 *********************************************************************/

#ifndef servercontroller_included
#define servercontroller_included

class servercontroller;
class dockServerController;
class ServMessage;
class ProcCommand;

#include <tqdict.h>
#include <tqpixmap.h>
#include <tqheader.h>
#include <tqtimer.h>

#include <klistview.h>
#include <kmainwindow.h>

#include "ksircprocess.h"
#include "ksircchannel.h"

//#include "puke/controller.h"
class TQLabel;
class KMenuBar;
class KSircServer;
class KGlobalAccel;
class nickColourMaker;
class dockServerController;

class ProcCommand // ServerController message
{
 public:
  static enum {
    addTopLevel,
    deleteTopLevel,
    procClose,
    newChannel,
    changeChannel,
    nickOnline,
    nickOffline,
    turnOffAutoCreate,
    turnOnAutoCreate
  } command;
};


class ServCommand // ServerController message
{
 public:
  static enum {
    updateFilters,
    updatePrefs
  } command;
};

class scInside : TQFrame
{
  Q_OBJECT
  TQ_OBJECT
  friend class servercontroller;
 public:
  scInside ( TQWidget *parent = 0L, const char * name = 0, WFlags f=0 );
  ~scInside();

 protected:
  virtual void resizeEvent ( TQResizeEvent * );

 private:
  KListView *ConnectionTree;
  TQLabel *ASConn;

};

class servercontroller : public KMainWindow
{
    Q_OBJECT
  TQ_OBJECT
    friend class dockServerController;
public:

    servercontroller ( TQWidget* parent = 0L, const char* name = NULL );
    virtual ~servercontroller();

    const TQDict<KSircProcess> &processes() const { return proc_list; }

    static servercontroller *self() { return s_self; }

    /**
     * Someone is talking to the user (blue icon), notify him (using the docked icon).
     */
    void increaseNotificationCount(const TQString& reason = TQString(), const TQString& text = TQString());

    /**
     * The channel in which the user was talked to, has been read.
     * -> decrease count of blue icons.
     */
    void decreaseNotificationCount(TQString reason = TQString());

    /**
     * This resets all notificaiton counts and allows new ones
     * this is used if we don't want to give the window
     * focus to reset focus
     */
    void resetNotification();

    void checkDocking();

    KGlobalAccel *getGlobalAccel(){ return m_kga; }

signals:
    /**
      * Filter rules have changed, need to re-read and update.
      */
    virtual void filters_update();

    void ServMessage(TQString server, int command, TQString args);

public slots:
    // All slots are described in servercontroll.cpp file
    /**
     * Does auto-joins on start up
     */
    virtual void do_autoconnect();
    /**
      * Creates popup asking for new connection
      */
    virtual void new_connection();
    /**
      *  Args:
      *    TQString: new server name or IP to connect to.
      *  Action:
      *	 Creates a new sirc process and window !default connected to the
      *	 server.  Does nothing if a server connection already exists.
      */
    //    virtual void new_ksircprocess(TQString);
    virtual void new_ksircprocess(KSircServer &);
    /**
      * Creates popup asking for new channel name
      */
    virtual void new_channel();
    /**
      *  Args:
      *    str: name of the new channel to be created
      *    server: name of the server channel is created on
      *  Action:
      *     opens a new toplevel on the requested channel and server
      */
    virtual void new_toplevel(const KSircChannel &channel);
    virtual void new_toplevel(const KSircChannel &channel, bool safe);
    /**
      * Action:
      *     Notify all ksircprocess' to update filters
      */
    virtual void slot_filters_update();
    virtual void ToggleAutoCreate();

    /**
     * Action: Popup a general preferences window which allows various
     * settings, etc.
     */
    virtual void general_prefs();
    /**
     * Opens the dialog that lets the user configure system notifications
     */
    virtual void notification_prefs();
    virtual void font_update(const TQFont&);
    virtual void filter_rule_editor();
    virtual void configChange();

    virtual void ProcMessage(TQString server, int command, TQString args);
    /**
     * On quit we sync the config to disk and exit
     */
    virtual void endksirc();
    /**
     * Start auto-connect
     */
    void start_autoconnect();
    /**
     * Start auto-connect with check
     */
    void start_autoconnect_check();


    TQListViewItem * findChild( TQListViewItem *parent, const TQString& text );

protected slots:
  void WindowSelected(TQListViewItem *);

  void dump_obj();
  void server_debug();

protected:

  virtual void showEvent( TQShowEvent *e );
  virtual void hideEvent( TQHideEvent *e );
  virtual void closeEvent( TQCloseEvent * );
  void saveDockingtqStatus();

  void saveGlobalProperties(KConfig *);
  void readGlobalProperties(KConfig *);

private:
    void saveSessionConfig();

    // La raison d'etre.  We don't run ConnectionTree ourselves, but
    // we get it from our helper class scInside.
    KListView *ConnectionTree;

    scInside *sci;

    // Menubar for the top.
    KMenuBar *MenuBar;

    // Hold a list of all KSircProcess's for access latter.  Index by server
    // name
    TQDict<KSircProcess> proc_list;
    TQPopupMenu *options, *connections;
    int join_id, server_id;

    KGlobalAccel *m_kga;

    int open_toplevels;

    TQPixmap pic_icon;
    TQPixmap pic_server;
    TQPixmap pic_gf;
    TQPixmap pic_run;
    TQPixmap pic_ppl;

//    PukeController *PukeC;

    // Holds dockable widget
    dockServerController *dockWidget;
    bool we_are_exiting;

    // Docked icon notification
    int m_notificationCount;
    struct ChannelSessionInfo
    {
	ChannelSessionInfo()
	    : desktop( -1 ) {}
	TQString name;
        TQString port;
	int desktop;
    };
    typedef TQValueList<ChannelSessionInfo> ChannelSessionInfoList;

    typedef TQMap<TQString, ChannelSessionInfoList> SessionConfigMap;
    SessionConfigMap m_sessionConfig;

    static servercontroller *s_self;

    TQTimer *at;

    nickColourMaker *m_ncm;
};
#endif // servercontroller_included
