
#ifndef _KSOPTS_H_
#define _KSOPTS_H_
#include <tqmap.h>
#include <tqdict.h>
#include <tqstring.h>
#include <tqstringlist.h>
#include <tqcolor.h>
#include <tqfont.h>
#include <tqrect.h>
#include <tqpixmap.h>
#include <tqdatetime.h>

#define IRC_SAFE_MAX_LINE 450

#include "boundscheckingarray.h"
#include "ksircchannel.h"
#include "ksircserver.h"

// Central place to hold KSirc's options
// and manage default values. The base classes
// are only used directly by the prefs dialog.
// The constructors initialize all options with default values.
class KSOGeneral
{
public:
    KSOGeneral();

    enum { SDI, MDI } displayMode;
    bool autoCreateWin : 1;
    bool autoCreateWinForNotice : 1;
    bool nickCompletion : 1;
    bool displayTopic : 1;
    bool oneLineEntry : 1;
    bool runDocked : 1;
//    bool timeStamp : 1;
//    bool beepNotify : 1;
    bool colorPicker : 1;
    bool autoRejoin : 1;
//    bool beepOnMsg : 1;
//    bool logging : 1;
    bool publicAway : 1;
    bool useColourNickList : 1;
    //    bool topicShow : 1;
    bool dockPopups : 1;
    bool autoSaveHistory : 1;
    int windowLength;
    TQString backgroundFile;

    TQPixmap backgroundPixmap();

private:
    TQPixmap m_backgroundPixmap;
};

class KSOChannel
{
public:
    KSOChannel();

    TQString server;
    TQString channel;

    bool timeStamp : 1;
    bool beepNotify : 1;
    bool beepOnMsg : 1;
    bool logging : 1;
    bool topicShow : 1;
    bool filterJoinPart : 1;
    TQString encoding;

    TQDateTime lastUsed;

    static bool applyGlobally;



};

class KSOServer
{
public:
    KSOServer();

    TQString server;
    bool globalCopy;

    TQString nick;
    TQString altNick;
    TQString realName;
    TQString userID;
    TQStringList notifyList;

    TQDateTime lastUsed;
};

class KSOStartup
{
public:
    KSOStartup();

    TQRect tqgeometry;
//    TQString nick;
//    TQString altNick;
//    TQString realName;
//    TQString userID;
//    TQStringList notifyList;
};

class KSOColors
{
public:
    enum { numColors = 16 };

    KSOColors();

    TQColor textColor;
    TQColor linkColor;
    TQColor infoColor;
    TQColor channelColor;
    TQColor errorColor;
    TQColor ownNickColor;
    bool ownNickBold : 1;
    bool ownNickUl : 1;
    bool ownNickRev : 1;

    TQColor msgContainNick; // needs config + impl
    TQColor msg1Contain;    // needs config
    TQString msg1String;    // needs config
    bool   msg1Regex;
    TQColor msg2Contain;    // need config
    TQString msg2String;    // needs config
    bool   msg2Regex;

    TQColor nickForeground;
    TQColor nickBackground;
    TQColor backgroundColor;
    TQColor selBackgroundColor;
    TQColor selForegroundColor;
    //TQColor ircColors[numColors];
    BoundsCheckingArray<TQColor, numColors> ircColors;
    BoundsCheckingArray<bool, numColors> nickHighlight;

    TQString colourTheme;

    TQFont defaultFont;
    bool ksircColors : 1;
    bool mircColors : 1;
    bool nickColourization : 1;

};

class KSORMBMenu
{
public:
    KSORMBMenu();
};

class KSOServChan
{
public:
    KSOServChan();
};

typedef TQMap<TQString, KSOChannel> ChannelOpMap;
typedef TQMap<TQString, ChannelOpMap> ServerChannelOpMap;
typedef TQMap<TQString, KSOServer> ServerOpMap;

class KSOptions
    : public KSOGeneral,
    public KSOStartup,
    public KSOColors,
    public KSORMBMenu,
    public KSOServChan
{
public:
    KSOptions() { s_options = this; }

    void load( int sections = -1 );
    void save( int sections = -1 );

    static KSOptions *options() { return s_options; }

    ServerChannelOpMap channel;
    ServerOpMap server;

    KSOChannel &chan( const KSircChannel &chanInfo )
    {
        return channel[chanInfo.server()][chanInfo.channel()];
    }

    KSOServer &serv( const KSircServer &servInfo )
    {
        return server[servInfo.server()];
    }

    void channelSetup(TQString serv, TQString chan);
    void applyChannelGlobal(void);

    void serverSetup(TQString server);
    void serverSetup( const KSircServer &servInfo )
    {
        serverSetup(servInfo.server());
    }

    enum {
        All = -1, General = 1, Startup = 2,
        Colors = 4, RMBMenu = 8, ServChan = 16,
        Channels = 32, Servers = 64
    };

private:
    static KSOptions *s_options;
};

#define ksopts (KSOptions::options())

#endif
