#ifndef KIODCCC_H
#define KIODCCC_H

#include <tqdict.h>
#include <tqobject.h>
#include <tqguardedptr.h>

#include "dccManager.h"
#include "dccToplevel.h"
#include "messageReceiver.h"

class KSProgress;

struct DCCInfo {
  TQString nick;
  TQString cancelMessage;
  int LastSize;
  int PercentSize;
  bool inProgress;
};

class KSircIODCC : public TQObject,
		   public KSircMessageReceiver
{
  Q_OBJECT
  TQ_OBJECT
public:
  KSircIODCC(KSircProcess *_proc);
  virtual ~KSircIODCC();

  virtual void sirc_receive(TQCString, bool broadcast);
  virtual void control_message(int, TQString);
  virtual filterRuleList *defaultRules();

  virtual void showMgr();

protected slots:
  void cancelTransfer(TQString);
  void getFile();
  void forgetFile();

  void dccConnectClicked(dccItem *);
  void dccResumeClicked(dccItem *);
  void dccRenameClicked(dccItem *);
  void dccAbortClicked(dccItem *);

  void dccRenameDone(dccItem *, TQString, TQString);

signals:
  void outputLine(TQCString);

private:
//  TQDict<TQProgressDialog> DlgList;
    //TQDict<KSProgress> DlgList;
    //TQDict<DCCInfo> DCCtqStatus;
  TQDict<dccItem> DCCGetItems;
  TQDict<dccItem> DCCSendItems;
  TQDict<dccItem> DCCChatItems;

  //dccDialog *pending;
  TQGuardedPtr<dccTopLevel> mgr;

  KSircProcess *proc;
};

#endif
