/* mode buttons for ksirc - Robbie Ward <linuxphreak@gmx.co.uk>*/

#include "chanButtons.h"
#include "chanButtons.moc"

#include <klocale.h>
#include <kpopupmenu.h>
#include <knuminput.h>
#include <kstdguiitem.h>
#include <kpushbutton.h>

#include <tqlayout.h>
#include <tqtooltip.h>
#include <tqlineedit.h>

#include "ksircprocess.h"

static void makeSquare(TQWidget *w)
{
   TQSize sh = w->tqsizeHint();
   int s = sh.height();
   w->setFixedSize(s,s);
}

chanButtons::chanButtons(KSircProcess *proc, TQWidget *parent, const char *name)
: TQWidget(parent, name),
  m_proc(proc)
{
  Popupmenu = new KPopupMenu( this );
  Popupmenu->insertTitle(i18n("Channel Modes"));
  toggleMenu[0] = Popupmenu->insertItem(i18n("i (invite-only)"), this, TQT_SLOT(invite()));
  toggleMenu[1] = Popupmenu->insertItem(i18n("l (limited users)"), this, TQT_SLOT(limited()));
  toggleMenu[2] = Popupmenu->insertItem(i18n("k (key to join)"), this, TQT_SLOT(key()));
  toggleMenu[3] = Popupmenu->insertItem(i18n("s (secret)"), this, TQT_SLOT(secret()));
  Popupmenu->insertSeparator();
  Popupmenu->insertTitle(i18n("User Modes"));
  toggleMenu[4] = Popupmenu->insertItem(i18n("i (be invisible)"), this, TQT_SLOT(invisible()));
  toggleMenu[5] = Popupmenu->insertItem(i18n("w (receive wallops)"), this, TQT_SLOT(wallops()));
  toggleMenu[6] = Popupmenu->insertItem(i18n("s (get server notices)"), this, TQT_SLOT(serverNotices()));

  tqlayout = new TQHBoxLayout(this);
  tqlayout->setSpacing(0);
  tqlayout->setMargin(0);

  protectButton = new TQPushButton(i18n("T"), this);
  protectButton->setToggleButton(true);
  makeSquare(protectButton);
  TQToolTip::add(protectButton, i18n("Only op'ed users can change the topic"));
  connect(protectButton, TQT_SIGNAL(clicked()), this, TQT_SLOT(protectMode()));
  tqlayout->addWidget(protectButton);

  outsideButton = new TQPushButton(i18n("N"), this);
  outsideButton->setToggleButton(true);
  makeSquare(outsideButton);
  TQToolTip::add(outsideButton, i18n("No outside messages"));
  connect(outsideButton, TQT_SIGNAL(clicked()), this, TQT_SLOT(outsideMode()));
  tqlayout->addWidget(outsideButton);

  moderateButton = new TQPushButton(i18n("M"), this);
  moderateButton->setToggleButton(true);
  makeSquare(moderateButton);
  TQToolTip::add(moderateButton, i18n("Only op'ed users and voiced users (+v) can speak"));
  connect(moderateButton, TQT_SIGNAL(clicked()), this, TQT_SLOT(moderateMode()));
  tqlayout->addWidget(moderateButton);

  menuButton = new TQPushButton(i18n("..."), this);
  makeSquare(menuButton);
  menuButton->setFixedWidth(menuButton->width()*2);
  menuButton->setPopup(Popupmenu);
  TQToolTip::add(menuButton, i18n("More mode commands"));
  tqlayout->addWidget(menuButton);
}

void chanButtons::invite()
{
  if (Popupmenu->isItemChecked(toggleMenu[0])) {
    Popupmenu->setItemChecked(toggleMenu[0], false);
    emit mode(TQString("-i"), 0);
  }
  else {
    Popupmenu->setItemChecked(toggleMenu[0], true);
    emit mode(TQString("+i"), 0);
  }
}

void chanButtons::limited()
{
  chanDialog = new chanbuttonsDialog(chanbuttonsDialog::limited);
  chanDialog->exec();
  if (chanDialog->sendLimitedUsers() == 0) {
    Popupmenu->setItemChecked(toggleMenu[1], false);
    emit mode(TQString("-l"), 0);
  }
  else {
    Popupmenu->setItemChecked(toggleMenu[1], true);
    emit mode(TQString("+l %1").tqarg(chanDialog->sendLimitedUsers()), 0);
  }
  delete chanDialog;
}

void chanButtons::key()
{
  chanDialog = new chanbuttonsDialog(chanbuttonsDialog::key);
  if (Popupmenu->isItemChecked(toggleMenu[2])) {
    chanDialog->exec();
    Popupmenu->setItemChecked(toggleMenu[2], false);
    emit mode(TQString("-k %1").tqarg(chanDialog->sendKey()), 0);
  }
  else {
    chanDialog->exec();
    Popupmenu->setItemChecked(toggleMenu[2], true);
    emit mode(TQString("+k %1").tqarg(chanDialog->sendKey()), 0);
  }
  delete chanDialog;
}

void chanButtons::secret()
{
  if (Popupmenu->isItemChecked(toggleMenu[3])) {
    Popupmenu->setItemChecked(toggleMenu[3], false);
    emit mode(TQString("-s"), 0);
  }
  else {
    Popupmenu->setItemChecked(toggleMenu[3], true);
    emit mode(TQString("+s"), 0);
  }
}

void chanButtons::invisible()
{
  if (Popupmenu->isItemChecked(toggleMenu[4])) {
    Popupmenu->setItemChecked(toggleMenu[4], false);
    emit mode(TQString("-i"), 1, m_proc->getNick());
  }
  else {
    Popupmenu->setItemChecked(toggleMenu[4], true);
    emit mode(TQString("+i"), 1, m_proc->getNick());
  }
}

void chanButtons::wallops()
{
  if (Popupmenu->isItemChecked(toggleMenu[5])) {
    Popupmenu->setItemChecked(toggleMenu[5], false);
    emit mode(TQString("-w"), 1, m_proc->getNick());
  }
  else {
    Popupmenu->setItemChecked(toggleMenu[5], true);
    emit mode(TQString("+w"), 1, m_proc->getNick());
  }
}

void chanButtons::serverNotices()
{
  if (Popupmenu->isItemChecked(toggleMenu[6])) {
    Popupmenu->setItemChecked(toggleMenu[6], false);
    emit mode(TQString("-s"), 1, m_proc->getNick());
  }
  else {
    Popupmenu->setItemChecked(toggleMenu[6], true);
    emit mode(TQString("+s"), 1, m_proc->getNick());
  }
}

void chanButtons::protectMode()
{
  if (protectButton->isOn())
    emit mode(TQString("+t"), 0);
  else
    emit mode(TQString("-t"), 0);
}

void chanButtons::outsideMode()
{
  if (outsideButton->isOn())
    emit mode(TQString("+n"), 0);
  else
    emit mode(TQString("-n"), 0);
}

void chanButtons::moderateMode()
{
  if (moderateButton->isOn())
    emit mode(TQString("+m"), 0);
  else
    emit mode(TQString("-m"), 0);
}

void chanButtons::setButtonsEnabled(bool enabled)
{
  // Set all the channel mode entries disabled if non-op else enable them
  protectButton->setEnabled(enabled);
  outsideButton->setEnabled(enabled);
  moderateButton->setEnabled(enabled);
  Popupmenu->setItemEnabled(toggleMenu[0], enabled);
  Popupmenu->setItemEnabled(toggleMenu[1], enabled);
  Popupmenu->setItemEnabled(toggleMenu[2], enabled);
  Popupmenu->setItemEnabled(toggleMenu[3], enabled);
}

void chanButtons::setMenuItemMode(int id, bool value)
{
  Popupmenu->setItemChecked(toggleMenu[id], value);
}

chanbuttonsDialog::chanbuttonsDialog(const type &modeType, TQWidget *parent,
                          const char *name, bool modal) : KDialog(parent, name, modal)
{
  m_sendKey = "";
  m_sendLimitedUsers = 0;
  resize(190, 82);
  setCaption(i18n("Limit Number of Users"));
  LimitedLayout = new TQVBoxLayout(this);
  LimitedLayout->setSpacing(9);
  LimitedLayout->setMargin(11);

  switch (modeType) {
    case limited:
      SpinBox = new KIntSpinBox(this);
      LimitedLayout->addWidget(SpinBox);
      break;
    case key:
      EditBox = new TQLineEdit(this);
      LimitedLayout->addWidget(EditBox);
      break;
  }

  Layout = new TQHBoxLayout;
  Layout->setSpacing(6);
  Layout->setMargin(0);

  okButton = new KPushButton(KStdGuiItem::ok(), this);
  okButton->tqsetSizePolicy(TQSizePolicy((TQSizePolicy::SizeType)1, (TQSizePolicy::SizeType)1,
                                      okButton->sizePolicy().hasHeightForWidth()));
  Layout->addWidget(okButton);
  switch (modeType) {
    case limited:
      connect(okButton, TQT_SIGNAL(clicked()), TQT_SLOT(limitedUsers()));
      break;
    case key:
      connect(okButton, TQT_SIGNAL(clicked()), TQT_SLOT(keyString()));
      break;
  }

  Layout->addWidget(okButton);

  cancelButton = new KPushButton(KStdGuiItem::cancel(), this);
  cancelButton->tqsetSizePolicy(TQSizePolicy((TQSizePolicy::SizeType)1, (TQSizePolicy::SizeType)1,
                                      cancelButton->sizePolicy().hasHeightForWidth()));
  Layout->addWidget(cancelButton);
  connect(cancelButton, TQT_SIGNAL(clicked()), TQT_SLOT(reject()));
  LimitedLayout->addLayout(Layout);

  TQSpacerItem *spacer = new TQSpacerItem(20, 20, TQSizePolicy::Minimum, TQSizePolicy::Expanding);
  LimitedLayout->addItem(spacer);
}

void chanbuttonsDialog::keyString()
{
  m_sendKey = EditBox->text();
  accept();
}

void chanbuttonsDialog::limitedUsers()
{
  m_sendLimitedUsers = SpinBox->value();
  accept();
}
