/***************************************************************************
                                trayicon.cpp
                             -------------------
    begin                : Tue Dec 11 2001
    copyright            : (C) 2001-2002 by Tim Jansen
    email                : tim@tjansen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "trayicon.h"
#include <tqtooltip.h>
#include <kstdaction.h>
#include <kapplication.h>
#include <klocale.h>
#include <kdialog.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <kpopupmenu.h>

KPassivePopup2::KPassivePopup2(TQWidget *parent) :
   KPassivePopup(parent){
}

void KPassivePopup2::hideEvent( TQHideEvent *e )
{
    KPassivePopup::hideEvent(e);
    emit hidden();
}

KPassivePopup2 *KPassivePopup2::message( const TQString &caption, const TQString &text,
				         const TQPixmap &icon,
				         TQWidget *parent)
{
    KPassivePopup2 *pop = new KPassivePopup2( parent);
    pop->setView( caption, text, icon );
    pop->show();

    return pop;
}


TrayIcon::TrayIcon(KDialog *d, Configuration *c) :
	KSystemTray(0, "krfb trayicon"),
	configuration(c),
	aboutDialog(d),
	actionCollection(this),
	quitting(false)
{
	KIconLoader *loader = KGlobal::iconLoader();
	trayIconOpen = loader->loadIcon("eyes-open24", KIcon::User);
	trayIconClosed = loader->loadIcon("eyes-closed24", KIcon::User);
	setPixmap(trayIconClosed);
	TQToolTip::add(this, i18n("Desktop Sharing - connecting"));

	manageInvitationsAction = new KAction(i18n("Manage &Invitations"), TQString(),
					      0, TQT_TQOBJECT(this), TQT_SIGNAL(showManageInvitations()),
					      &actionCollection);
	manageInvitationsAction->plug(contextMenu());

	contextMenu()->insertSeparator();

	enableControlAction = new KToggleAction(i18n("Enable Remote Control"));
	enableControlAction->setCheckedState(i18n("Disable Remote Control"));
	enableControlAction->plug(contextMenu());
	enableControlAction->setEnabled(false);
	connect(enableControlAction, TQT_SIGNAL(toggled(bool)), TQT_SIGNAL(enableDesktopControl(bool)));

	contextMenu()->insertSeparator();

	aboutAction = KStdAction::aboutApp(TQT_TQOBJECT(this), TQT_SLOT(showAbout()), &actionCollection);
	aboutAction->plug(contextMenu());

	show();
}

TrayIcon::~TrayIcon(){
}

void TrayIcon::showAbout() {
	aboutDialog->show();
}

void TrayIcon::prepareQuit() {
        quitting = true;
}



void TrayIcon::showConnectedMessage(TQString host) {

        setPixmap(trayIconOpen);
        KPassivePopup2::message(i18n("Desktop Sharing"),
				i18n("The remote user has been authenticated and is now connected."),
				trayIconOpen,
				this);
	TQToolTip::add(this, i18n("Desktop Sharing - connected with %1").tqarg(host));
}

void TrayIcon::showDisconnectedMessage() {
        if (quitting)
                return;

	TQToolTip::add(this, i18n("Desktop Sharing - disconnected"));
        setPixmap(trayIconClosed);
        KPassivePopup2 *p = KPassivePopup2::message(i18n("Desktop Sharing"),
						    i18n("The remote user has closed the connection."),
						    trayIconClosed,
						    this);
	connect(p, TQT_SIGNAL(hidden()), this, TQT_SIGNAL(diconnectedMessageDisplayed()));
}

void TrayIcon::setDesktopControlSetting(bool b) {
	enableControlAction->setEnabled(true);
	enableControlAction->setChecked(b);
}

void TrayIcon::mousePressEvent(TQMouseEvent *e)
{
        if (!TQT_TQRECT_OBJECT(rect()).contains(e->pos()))
                return;

	if (e->button() == Qt::LeftButton) {
	        contextMenuAboutToShow(contextMenu());
		contextMenu()->popup(e->globalPos());
	}
	else
	        KSystemTray::mousePressEvent(e);
}

#include "trayicon.moc"
